<?php
// Start session for navbar
session_start();
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <title>JV Overseas Education - About Us</title>
    <meta content="width=device-width, initial-scale=1.0" name="viewport">
    <meta name="keywords" content="About Us">
    <meta name="description" content="JV Overseas Education Uganda - Leading educational consultancy helping students access higher education worldwide">

    <!-- Favicon -->
    <link href="img/favicon.ico" rel="icon">

    <!-- Google Web Fonts -->
    <link rel="preconnect" href="https://fonts.gstatic.com">
    <link href="https://fonts.googleapis.com/css2?family=Jost:wght@500;600;700&family=Open+Sans:wght@400;600&display=swap" rel="stylesheet"> 
    <link href="https://fonts.googleapis.com/css?family=Newsreader+16pt:200,200i,300,300i,400,400i,500,500i,600,600i,700,700i,800,800i" rel="stylesheet">

    <!-- Font Awesome -->
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.10.0/css/all.min.css" rel="stylesheet">

    <!-- Libraries Stylesheet -->
    <link href="lib/owlcarousel/assets/owl.carousel.min.css" rel="stylesheet">

    <!-- Customized Bootstrap Stylesheet -->
    <link href="css/style.css" rel="stylesheet">
</head>

<body>
    <?php include 'navbar.php'; ?>

    <!-- Header Start -->
    <div class="jumbotron jumbotron-fluid page-header position-relative overlay-bottom" style="margin-bottom: 90px; background-color: #3fb7fe;">
        <div class="container text-center py-5">
            <h1 class="text-white display-1">About Us</h1>
            <div class="d-inline-flex text-white mb-5">
                <p class="m-0 text-uppercase"><a class="text-white" href="index.php">Home</a></p>
                <i class="fa fa-angle-double-right pt-1 px-3"></i>
                <p class="m-0 text-uppercase">About Us</p>
            </div>
        </div>
    </div>
    <!-- Header End -->

    <!-- About Start -->
    <div class="container-fluid py-5">
        <div class="container py-5">
            <div class="row">
                <div class="col-lg-5 mb-5 mb-lg-0" style="min-height: 500px;">
                    <div class="position-relative h-100">
                        <img class="position-absolute w-100 h-100" src="images/student.jpg" style="object-fit: cover;">
                    </div>
                </div>
                <div class="col-lg-7">
                    <div class="section-title position-relative mb-4">
                        <h6 class="d-inline-block position-relative text-secondary text-uppercase pb-2">About Us</h6>
                        <h1 class="display-4">JV Overseas Education Uganda</h1>
                    </div>
                    <p><strong>Overview:</strong> JV Overseas Education Uganda is a leading educational consultancy based in Uganda, dedicated to helping students from Uganda, East Africa, and the broader African continent gain access to higher education institutions worldwide. With a strong network of partnerships with universities across the Schengen area, the UK, USA, Cyprus, Canada, and more, we provide comprehensive support to ensure students achieve their academic and career goals at all levels of higher education, including undergraduate, master's, and PhD programs.</p>
                    
                    <p><strong>Mission Statement:</strong> Our mission is to empower students by providing tailored advice and support throughout their journey to studying abroad, making higher education opportunities accessible, affordable, and aligned with each student's aspirations and budget.</p>
                    
                    <p><strong>Vision Statement:</strong> To be the leading education consultancy in East Africa, recognized for our dedication to student success and our comprehensive support services that enable students to achieve their educational and career dreams globally.</p>
                    
                    <a href="contact.php" class="btn btn-primary py-2 px-4 mt-3">Contact Us</a>
                </div>
            </div>
        </div>
    </div>
    <!-- About End -->

    <!-- Features Start -->
    <div class="container-fluid py-5">
        <div class="container py-5">
            <div class="row">
                <div class="col-lg-7 mb-5 mb-lg-0">
                    <div class="section-title position-relative mb-4">
                        <h6 class="d-inline-block position-relative text-secondary text-uppercase pb-2">Why Choose Us?</h6>
                        <h1 class="display-4">Our Commitment to Your Success</h1>
                    </div>
                    <div class="d-flex mb-3">
                        <div class="btn-icon bg-primary mr-4">
                            <i class="fa fa-2x fa-globe text-white"></i>
                        </div>
                        <div class="mt-n1">
                            <h4>Global Network</h4>
                            <p>We have established partnerships with universities across multiple countries, giving you access to the best educational opportunities worldwide.</p>
                        </div>
                    </div>
                    <div class="d-flex mb-3">
                        <div class="btn-icon bg-secondary mr-4">
                            <i class="fa fa-2x fa-user-graduate text-white"></i>
                        </div>
                        <div class="mt-n1">
                            <h4>Personalized Guidance</h4>
                            <p>We provide tailored advice to match your academic goals, financial situation, and career aspirations with the right institutions.</p>
                        </div>
                    </div>
                    <div class="d-flex">
                        <div class="btn-icon bg-warning mr-4">
                            <i class="fa fa-2x fa-hands-helping text-white"></i>
                        </div>
                        <div class="mt-n1">
                            <h4>End-to-End Support</h4>
                            <p class="m-0">From application to visa processing and pre-departure preparation, we support you through every step of your journey.</p>
                        </div>
                    </div>
                </div>
                <div class="col-lg-5" style="min-height: 500px;">
                    <div class="position-relative h-100">
                        <img class="position-absolute w-100 h-100" src="img/feature.jpg" style="object-fit: cover;">
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- Features End -->

    <!-- Conclusion Start -->
    <div class="container-fluid bg-dark text-white-50 py-5">
        <div class="container py-5">
            <div class="row">
                <div class="col-12 text-center">
                    <h3 class="text-white mb-4">CONCLUSION</h3>
                    <p class="mb-0">JV Overseas Education Uganda is dedicated to helping students realize their educational and career dreams by providing expert guidance and support. With a proven track record and a strong network of partnerships, we are committed to making higher education opportunities accessible and achievable for students in Uganda, East Africa, and beyond.</p>
                </div>
            </div>
        </div>
    </div>
    <!-- Conclusion End -->

<!-- Footer Start -->
<div class="container-fluid position-relative overlay-top bg-dark text-white-50 py-5" style="margin-top: 90px;">
    <div class="container mt-5 pt-5">
        <div class="row">
            <div class="col-md-6 mb-5">
                <a href="index.php" class="navbar-brand">
                    <img src="img/jhoverseas.jpg" alt="JV Overseas Logo" style="height: 50px;">
                </a>
                <p class="m-0">JV Overseas Education Uganda is a leading educational consultancy helping students access higher education opportunities worldwide.</p>
            </div>
            <div class="col-md-6 mb-5">
                <h3 class="text-white mb-4">Quick Links</h3>
                <div class="d-flex flex-column justify-content-start">
                    <a class="text-white-50 mb-2" href="index.php"><i class="fa fa-angle-right mr-2"></i>Home</a>
                    <a class="text-white-50 mb-2" href="about.php"><i class="fa fa-angle-right mr-2"></i>About Us</a>
                    <a class="text-white-50 mb-2" href="services.php"><i class="fa fa-angle-right mr-2"></i>Services</a>
                    <a class="text-white-50 mb-2" href="universities.php"><i class="fa fa-angle-right mr-2"></i>Universities</a>
                    <a class="text-white-50 mb-2" href="apply.php"><i class="fa fa-angle-right mr-2"></i>Free Consultation</a>
                    <a class="text-white-50 mb-2" href="contact.php"><i class="fa fa-angle-right mr-2"></i>Contact Us</a>
                </div>
            </div>
        </div>
        <div class="row">
            <div class="col-md-6 mb-5">
                <h3 class="text-white mb-4">Get In Touch</h3>
                <p class="m-0"><i class="fa fa-map-marker-alt mr-2"></i>Kampala, Uganda</p>
                <p class="m-0"><i class="fa fa-phone-alt mr-2"></i><a href="tel:+256788289235" class="text-white-50">+256 788 289 235</a></p>
                <p class="m-0"><i class="fa fa-envelope mr-2"></i><a href="mailto:info@jvoverseas.com" class="text-white-50">info@jvoverseas.com</a></p>
                <div class="d-flex flex-column justify-content-start">
                    <div class="d-flex align-items-center mt-2">
                        <a class="text-white-50 mr-2" href="#"><i class="fab fa-twitter"></i></a>
                        <a class="text-white-50 mr-2" href="#"><i class="fab fa-facebook-f"></i></a>
                        <a class="text-white-50 mr-2" href="#"><i class="fab fa-linkedin-in"></i></a>
                        <a class="text-white-50 mr-2" href="#"><i class="fab fa-instagram"></i></a>
                    </div>
                </div>
            </div>
            <div class="col-md-6 mb-5">
                <h3 class="text-white mb-4">Newsletter</h3>
                <p>Stay updated with our latest news and education opportunities.</p>
                <form action="newsletter-subscribe.php" method="POST">
                    <div class="form-inline">
                        <div class="input-group">
                            <input type="email" class="form-control" name="email" placeholder="Your Email" required>
                            <div class="input-group-append">
                                <button class="btn btn-primary" type="submit">Subscribe</button>
                            </div>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
<!-- Footer End -->

<!-- Back to Top -->
<a href="#" class="btn btn-lg btn-primary rounded-0 btn-lg-square back-to-top"><i class="fa fa-angle-double-up"></i></a>

<!-- JavaScript Libraries -->
<script src="https://code.jquery.com/jquery-3.4.1.min.js"></script>
<script src="https://stackpath.bootstrapcdn.com/bootstrap/4.4.1/js/bootstrap.bundle.min.js"></script>
<script src="lib/easing/easing.min.js"></script>
<script src="lib/waypoints/waypoints.min.js"></script>
<script src="lib/counterup/counterup.min.js"></script>
<script src="lib/owlcarousel/owl.carousel.min.js"></script>
<script src="mail/jqBootstrapValidation.min.js"></script>
<script src="mail/contact.js"></script>
<script src="js/main.js"></script>

<script>
// Set current year in footer
document.getElementById('year')?.textContent = new Date().getFullYear();
</script>
<!-- Video Modal -->
<div class="modal fade" id="videoModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-body">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>        
                <!-- 16:9 aspect ratio -->
                <div class="embed-responsive embed-responsive-16by9">
                    <iframe class="embed-responsive-item" src="" id="video" allowscriptaccess="always" allow="autoplay"></iframe>
                </div>
            </div>
        </div>
    </div>
</div>

<script src="https://code.jquery.com/jquery-3.4.1.min.js"></script>
<script src="https://stackpath.bootstrapcdn.com/bootstrap/4.4.1/js/bootstrap.bundle.min.js"></script>
<script src="lib/easing/easing.min.js"></script>
<script src="lib/waypoints/waypoints.min.js"></script>
<script src="lib/counterup/counterup.min.js"></script>
<script src="lib/owlcarousel/owl.carousel.min.js"></script>
<script src="mail/jqBootstrapValidation.min.js"></script>
<script src="mail/contact.js"></script>
<script src="js/main.js"></script>
<script>
    // Video modal
    $(document).ready(function () {
        var $videoSrc;
        $('.btn-play').click(function () {
            $videoSrc = $(this).data("src");
        });
        console.log($videoSrc);

        $('#videoModal').on('shown.bs.modal', function (e) {
            $("#video").attr('src', $videoSrc + "?autoplay=1&amp;modestbranding=1&amp;showinfo=0");
        })

        $('#videoModal').on('hide.bs.modal', function (e) {
            $("#video").attr('src', $videoSrc);
        })
    });
</script>
</body>
</html>