<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <title>Create Student - JV Overseas Education</title>
    <meta content="width=device-width, initial-scale=1.0" name="viewport">
    <link rel="preconnect" href="https://fonts.gstatic.com">
    <link href="https://fonts.googleapis.com/css2?family=Jost:wght@500;600;700&family=Open+Sans:wght@400;600&display=swap" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.10.0/css/all.min.css" rel="stylesheet">
    <link href="lib/owlcarousel/assets/owl.carousel.min.css" rel="stylesheet">
    <link href="css/style.css" rel="stylesheet">
    <style>
        .form-section {
            margin-bottom: 30px;
            padding-bottom: 20px;
            border-bottom: 1px solid #eee;
        }
        .form-section:last-child {
            border-bottom: none;
            margin-bottom: 0;
            padding-bottom: 0;
        }
        .section-title {
            margin-bottom: 20px;
            padding-bottom: 10px;
            border-bottom: 2px solid #3fb7fe;
        }
        .profile-upload {
            position: relative;
            display: inline-block;
        }
        .upload-overlay {
            position: absolute;
            top: 0;
            left: 0;
            width: 150px;
            height: 150px;
            border-radius: 50%;
            background: rgba(0,0,0,0.5);
            color: white;
            display: flex;
            align-items: center;
            justify-content: center;
            opacity: 0;
            transition: all 0.3s;
        }
        .profile-upload:hover .upload-overlay {
            opacity: 1;
        }
        .file-input {
            display: none;
        }
        .profile-img {
            width: 150px;
            height: 150px;
            object-fit: cover;
            border-radius: 50%;
            border: 5px solid #3fb7fe;
        }
        .preference-checkbox {
            margin-bottom: 10px;
        }
        .info-box {
            background: #f8f9fa;
            border-left: 4px solid #3fb7fe;
            padding: 15px;
            margin: 20px 0;
            border-radius: 5px;
        }
    </style>
</head>
<body>

<?php include 'admin-navbar.php'; ?>

<div class="container py-5">
    <div class="section-title position-relative mb-4">
        <h6 class="d-inline-block position-relative text-secondary text-uppercase pb-2">Admin Panel</h6>
        <h1 class="display-5">Create New Student Account</h1>
    </div>

    <?php if (isset($error)): ?>
        <div class="alert alert-danger"><?= htmlspecialchars($error) ?></div>
    <?php endif; ?>
    
    <?php if (isset($success)): ?>
        <div class="alert alert-success"><?= htmlspecialchars($success) ?></div>
        <div class="text-center mb-4">
            <a href="admin-manage-students.php" class="btn btn-primary">View All Students</a>
        </div>
    <?php endif; ?>

    <form method="POST" enctype="multipart/form-data">
        <div class="form-section">
            <h5 class="section-title">Personal Information</h5>
            <div class="row">
                <div class="col-md-6 mb-3">
                    <label>First Name *</label>
                    <input type="text" name="first_name" class="form-control" 
                           value="<?= htmlspecialchars($_POST['first_name'] ?? '') ?>" required>
                </div>
                <div class="col-md-6 mb-3">
                    <label>Last Name *</label>
                    <input type="text" name="last_name" class="form-control" 
                           value="<?= htmlspecialchars($_POST['last_name'] ?? '') ?>" required>
                </div>
            </div>
            <div class="row">
                <div class="col-md-6 mb-3">
                    <label>Email Address *</label>
                    <input type="email" name="email" class="form-control" 
                           value="<?= htmlspecialchars($_POST['email'] ?? '') ?>" required>
                </div>
                <div class="col-md-6 mb-3">
                    <label>Phone Number</label>
                    <input type="text" name="phone" class="form-control" 
                           value="<?= htmlspecialchars($_POST['phone'] ?? '') ?>">
                </div>
            </div>
            <div class="row">
                <div class="col-md-6 mb-3">
                    <label>Password *</label>
                    <input type="password" name="password" class="form-control" required>
                    <small class="form-text text-muted">Must be at least 6 characters</small>
                </div>
                <div class="col-md-6 mb-3">
                    <label>Confirm Password *</label>
                    <input type="password" name="confirm_password" class="form-control" required>
                </div>
            </div>
        </div>
        
        <div class="form-section">
            <h5 class="section-title">Profile Photo</h5>
            <div class="d-flex align-items-center">
                <div class="profile-upload">
                    <img src="img/profile-placeholder.jpg" class="profile-img" alt="Profile" id="profilePreview">
                    <div class="upload-overlay">
                        <i class="fas fa-camera"></i>
                    </div>
                    <input type="file" name="profile_photo" id="profilePhoto" class="file-input" accept="image/*">
                </div>
                <div class="ml-4">
                    <p><strong>Upload Profile Photo</strong></p>
                    <p class="text-muted small">JPG, PNG, or GIF (max 5MB)</p>
                    <p class="text-muted small">Recommended: 400×400 pixels</p>
                </div>
            </div>
        </div>
        
        <div class="form-section">
            <h5 class="section-title">Academic Information</h5>
            <div class="row">
                <div class="col-md-6 mb-3">
                    <label>Education Level *</label>
                    <select name="education_level" class="form-control" required>
                        <option value="">Select Level</option>
                        <option value="high_school" <?= ($_POST['education_level'] ?? '') === 'high_school' ? 'selected' : '' ?>>High School</option>
                        <option value="undergraduate" <?= ($_POST['education_level'] ?? '') === 'undergraduate' ? 'selected' : '' ?>>Undergraduate</option>
                        <option value="graduate" <?= ($_POST['education_level'] ?? '') === 'graduate' ? 'selected' : '' ?>>Graduate</option>
                        <option value="phd" <?= ($_POST['education_level'] ?? '') === 'phd' ? 'selected' : '' ?>>PhD</option>
                    </select>
                </div>
                <div class="col-md-6 mb-3">
                    <label>Current Institution</label>
                    <input type="text" name="current_institution" class="form-control" 
                           value="<?= htmlspecialchars($_POST['current_institution'] ?? '') ?>">
                </div>
            </div>
            <div class="row">
                <div class="col-md-6 mb-3">
                    <label>GPA</label>
                    <input type="number" name="gpa" class="form-control" step="0.01" min="0" max="4.0"
                           value="<?= htmlspecialchars($_POST['gpa'] ?? '') ?>">
                    <small class="form-text text-muted">Scale of 0.00 to 4.00</small>
                </div>
                <div class="col-md-6 mb-3">
                    <label>Budget ($)</label>
                    <input type="number" name="budget" class="form-control" min="0"
                           value="<?= htmlspecialchars($_POST['budget'] ?? '') ?>">
                    <small class="form-text text-muted">Annual budget for studies</small>
                </div>
            </div>
        </div>
        
        <div class="form-section">
            <h5 class="section-title">Preferences</h5>
            <div class="row">
                <div class="col-md-6 mb-3">
                    <label>Preferred Countries *</label>
                    <div class="form-check preference-checkbox">
                        <input class="form-check-input" type="checkbox" name="preferred_countries[]" value="United Kingdom" id="uk" checked>
                        <label class="form-check-label" for="uk">United Kingdom</label>
                    </div>
                    <div class="form-check preference-checkbox">
                        <input class="form-check-input" type="checkbox" name="preferred_countries[]" value="United States" id="usa" checked>
                        <label class="form-check-label" for="usa">United States</label>
                    </div>
                    <div class="form-check preference-checkbox">
                        <input class="form-check-input" type="checkbox" name="preferred_countries[]" value="Canada" id="canada">
                        <label class="form-check-label" for="canada">Canada</label>
                    </div>
                    <div class="form-check preference-checkbox">
                        <input class="form-check-input" type="checkbox" name="preferred_countries[]" value="Australia" id="australia">
                        <label class="form-check-label" for="australia">Australia</label>
                    </div>
                    <div class="form-check preference-checkbox">
                        <input class="form-check-input" type="checkbox" name="preferred_countries[]" value="Germany" id="germany">
                        <label class="form-check-label" for="germany">Germany</label>
                    </div>
                    <div class="form-check preference-checkbox">
                        <input class="form-check-input" type="checkbox" name="preferred_countries[]" value="France" id="france">
                        <label class="form-check-label" for="france">France</label>
                    </div>
                </div>
                <div class="col-md-6 mb-3">
                    <label>Preferred Courses *</label>
                    <div class="form-check preference-checkbox">
                        <input class="form-check-input" type="checkbox" name="preferred_courses[]" value="Engineering" id="engineering" checked>
                        <label class="form-check-label" for="engineering">Engineering</label>
                    </div>
                    <div class="form-check preference-checkbox">
                        <input class="form-check-input" type="checkbox" name="preferred_courses[]" value="Business" id="business" checked>
                        <label class="form-check-label" for="business">Business</label>
                    </div>
                    <div class="form-check preference-checkbox">
                        <input class="form-check-input" type="checkbox" name="preferred_courses[]" value="Computer Science" id="cs">
                        <label class="form-check-label" for="cs">Computer Science</label>
                    </div>
                    <div class="form-check preference-checkbox">
                        <input class="form-check-input" type="checkbox" name="preferred_courses[]" value="Medicine" id="medicine">
                        <label class="form-check-label" for="medicine">Medicine</label>
                    </div>
                    <div class="form-check preference-checkbox">
                        <input class="form-check-input" type="checkbox" name="preferred_courses[]" value="Law" id="law">
                        <label class="form-check-label" for="law">Law</label>
                    </div>
                    <div class="form-check preference-checkbox">
                        <input class="form-check-input" type="checkbox" name="preferred_courses[]" value="Arts" id="arts">
                        <label class="form-check-label" for="arts">Arts & Humanities</label>
                    </div>
                </div>
            </div>
        </div>
        
        <div class="form-section">
            <h5 class="section-title">Assignment & Status</h5>
            <div class="row">
                <div class="col-md-6 mb-3">
                    <label>Assign to Counselor</label>
                    <select name="assigned_counselor_id" class="form-control">
                        <option value="">Not Assigned</option>
                        <?php foreach ($counselors as $c): ?>
                        <option value="<?= $c['id'] ?>" <?= ($_POST['assigned_counselor_id'] ?? '') == $c['id'] ? 'selected' : '' ?>>
                            <?= htmlspecialchars($c['first_name'] . ' ' . $c['last_name']) ?>
                        </option>
                        <?php endforeach; ?>
                    </select>
                </div>
                <div class="col-md-6 mb-3">
                    <label>Status *</label>
                    <select name="status" class="form-control" required>
                        <option value="prospective" <?= ($_POST['status'] ?? 'prospective') === 'prospective' ? 'selected' : '' ?>>Prospective</option>
                        <option value="active" <?= ($_POST['status'] ?? 'prospective') === 'active' ? 'selected' : '' ?>>Active</option>
                        <option value="admitted" <?= ($_POST['status'] ?? 'prospective') === 'admitted' ? 'selected' : '' ?>>Admitted</option>
                        <option value="rejected" <?= ($_POST['status'] ?? 'prospective') === 'rejected' ? 'selected' : '' ?>>Rejected</option>
                        <option value="alumni" <?= ($_POST['status'] ?? 'prospective') === 'alumni' ? 'selected' : '' ?>>Alumni</option>
                    </select>
                </div>
            </div>
        </div>
        
        <div class="info-box">
            <h6><i class="fas fa-info-circle"></i> What Happens Next?</h6>
            <ul class="small">
                <li>The student will receive an email with their login credentials</li>
                <li>They can log in and update their profile information</li>
                <li>The assigned counselor will be notified of the new student</li>
                <li>The student will appear in the counselor's student list</li>
            </ul>
        </div>
        
        <div class="text-center">
            <button type="submit" name="create_student" class="btn btn-primary btn-lg px-5">Create Student Account</button>
        </div>
        
        <div class="text-center mt-3">
            <a href="admin-manage-students.php" class="btn btn-outline-primary">Cancel</a>
        </div>
    </form>
</div>

<?php include 'footer.php'; ?>
<script src="https://code.jquery.com/jquery-3.4.1.min.js"></script>
<script src="https://stackpath.bootstrapcdn.com/bootstrap/4.4.1/js/bootstrap.bundle.min.js"></script>
<script>
    // Profile photo upload functionality
    document.getElementById('profilePhoto').addEventListener('change', function(e) {
        const file = e.target.files[0];
        if (file) {
            // Update preview
            const reader = new FileReader();
            reader.onload = function(e) {
                document.getElementById('profilePreview').src = e.target.result;
            };
            reader.readAsDataURL(file);
        }
    });
    
    // Allow clicking on the image to change photo
    document.getElementById('profilePreview').addEventListener('click', function() {
        document.getElementById('profilePhoto').click();
    });
    
    // Form submission confirmation
    $('form').on('submit', function(e) {
        const firstName = $('input[name="first_name"]').val();
        const lastName = $('input[name="last_name"]').val();
        
        if (firstName && lastName && confirm(`You are about to create a student account for ${firstName} ${lastName}. Continue?`)) {
            return true;
        } else {
            e.preventDefault();
        }
    });
</script>
</body>
</html>