<?php
/**
 * Admin Portal Navigation Bar
 * Reusable navbar for all admin dashboard pages
 */
?>

<!-- Navbar Start -->
<div class="container-fluid p-0">
    <nav class="navbar navbar-expand-lg bg-white navbar-light py-3 py-lg-0 px-lg-5">
        <a href="../index.php" class="navbar-brand ml-lg-3">
            <img src="img/jhoverseas.jpg" alt="JV Overseas Education" style="height: 60px;">
        </a>
        <button type="button" class="navbar-toggler" data-toggle="collapse" data-target="#navbarCollapse">
            <span class="navbar-toggler-icon"></span>
        </button>
        <div class="collapse navbar-collapse justify-content-between px-lg-3" id="navbarCollapse">
            <div class="navbar-nav mx-auto py-0">
                <!-- Dashboard -->
                <a href="admin-dashboard.php" class="nav-item nav-link">Dashboard</a>
                
                <!-- User Management -->
                <div class="nav-item dropdown">
                    <a href="#" class="nav-link dropdown-toggle" data-toggle="dropdown">User Management</a>
                    <div class="dropdown-menu m-0">
                        <a href="admin-manage-students.php" class="dropdown-item">Manage Students</a>
                        <a href="admin-manage-counselors.php" class="dropdown-item">Manage Counselors</a>
                        <a href="admin-manage-admins.php" class="dropdown-item">Manage Admins</a>
                        <div class="dropdown-divider"></div>
                        <a href="admin-create-student.php" class="dropdown-item">Create Student</a>
                        <a href="admin-create-counselor.php" class="dropdown-item">Create Counselor</a>
                        <a href="admin-create-admin.php" class="dropdown-item">Create Admin</a>
                    </div>
                </div>
                
                <!-- Applications -->
                <div class="nav-item dropdown">
                    <a href="#" class="nav-link dropdown-toggle" data-toggle="dropdown">Applications</a>
                    <div class="dropdown-menu m-0">
                        <a href="admin-applications.php" class="dropdown-item">All Applications</a>
                        <a href="admin-applications.php?status=submitted" class="dropdown-item">Submitted</a>
                        <a href="admin-applications.php?status=under_review" class="dropdown-item">Under Review</a>
                        <a href="admin-applications.php?status=accepted" class="dropdown-item">Accepted</a>
                        <a href="admin-applications.php?status=rejected" class="dropdown-item">Rejected</a>
                        <div class="dropdown-divider"></div>
                        <a href="admin-create-application.php" class="dropdown-item">Create Application</a>
                    </div>
                </div>
                
                <!-- Academic Management -->
                <div class="nav-item dropdown">
                    <a href="#" class="nav-link dropdown-toggle" data-toggle="dropdown">Academic</a>
                    <div class="dropdown-menu m-0">
                        <a href="admin-universities.php" class="dropdown-item">Universities</a>
                        <a href="admin-programs.php" class="dropdown-item">Programs</a>
                        <a href="admin-countries.php" class="dropdown-item">Countries</a>
                        <a href="admin-visa-checklist.php" class="dropdown-item">Visa Checklist</a>
                        <div class="dropdown-divider"></div>
						<a href="admin-document-verification.php" class="dropdown-item">Document Verification</a>
                        <a href="admin-create-university.php" class="dropdown-item">Add University</a>
                        <a href="admin-create-program.php" class="dropdown-item">Add Program</a>
                        <a href="admin-create-country.php" class="dropdown-item">Add Country</a>
                    </div>
                </div>
                
                <!-- Financial Management -->
                <div class="nav-item dropdown">
                    <a href="#" class="nav-link dropdown-toggle" data-toggle="dropdown">Financial</a>
                    <div class="dropdown-menu m-0">
                        <a href="admin-payments.php" class="dropdown-item">Payments</a>
                        <a href="admin-invoices.php" class="dropdown-item">Invoices</a>
                        <a href="admin-payment-types.php" class="dropdown-item">Payment Types</a>
                        <div class="dropdown-divider"></div>
                        <a href="admin-create-invoice.php" class="dropdown-item">Create Invoice</a>
                        <a href="admin-create-payment.php" class="dropdown-item">Record Payment</a>
                    </div>
                </div>
                
                <!-- Content Management -->
                <div class="nav-item dropdown">
                    <a href="#" class="nav-link dropdown-toggle" data-toggle="dropdown">Content</a>
                    <div class="dropdown-menu m-0">
                        <a href="admin-website-content.php" class="dropdown-item">Website Content</a>
                        <a href="admin-blog-posts.php" class="dropdown-item">Blog Posts</a>
                        <a href="admin-testimonials.php" class="dropdown-item">Testimonials</a>
                        <a href="admin-settings.php" class="dropdown-item">System Settings</a>
                        <div class="dropdown-divider"></div>
                        <a href="admin-create-blog-post.php" class="dropdown-item">Create Blog Post</a>
                        <a href="admin-create-testimonial.php" class="dropdown-item">Add Testimonial</a>
                    </div>
                </div>
                
                <!-- Reports & Analytics -->
                <div class="nav-item dropdown">
                    <a href="#" class="nav-link dropdown-toggle" data-toggle="dropdown">Reports</a>
                    <div class="dropdown-menu m-0">
                        <a href="admin-reports-students.php" class="dropdown-item">Student Reports</a>
                        <a href="admin-reports-applications.php" class="dropdown-item">Application Reports</a>
                        <a href="admin-reports-financial.php" class="dropdown-item">Financial Reports</a>
                        <a href="admin-reports-performance.php" class="dropdown-item">Counselor Performance</a>
                        <a href="admin-reports-visa-success.php" class="dropdown-item">Visa Success Rates</a>
                    </div>
                </div>
                
                <!-- System -->
                <div class="nav-item dropdown">
                    <a href="#" class="nav-link dropdown-toggle" data-toggle="dropdown">System</a>
                    <div class="dropdown-menu m-0">
                        <a href="admin-activities.php" class="dropdown-item">Activity Log</a>
                        <a href="admin-notifications.php" class="dropdown-item">Notifications</a>
                        <a href="admin-backup.php" class="dropdown-item">Database Backup</a>
                        <a href="admin-cache.php" class="dropdown-item">Clear Cache</a>
                        <a href="admin-api-keys.php" class="dropdown-item">API Keys</a>
                    </div>
                </div>
            </div>
            <div class="auth-links">
                <a href="admin-profile.php" class="btn btn-outline-primary">Profile</a>
                <a href="admin-dashboard.php?logout=1" class="btn btn-primary">Logout</a>
            </div>
        </div>
    </nav>
</div>
<!-- Navbar End -->