<?php
header('Content-Type: application/json');
require_once '../config.php';
check_api_login();

$user = $_SESSION['user'];
$notifications = get_user_notifications($user['id']);

// Mark as read if requested
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['mark_read'])) {
    mark_notifications_read($user['id']);
    $notifications = get_user_notifications($user['id']);
}

echo json_encode([
    'success' => true,
    'notifications' => $notifications,
    'unread_count' => count(array_filter($notifications, fn($n) => !$n['is_read']))
]);