<?php
session_start();
require_once 'config.php';

if (!isset($_SESSION['user_id']) || $_SESSION['user_type'] !== 'counselor') {
    header('Location: counselor-login.php');
    exit;
}

// Get applications assigned to this counselor
$stmt = $pdo->prepare("SELECT a.*, s.first_name, s.last_name, s.email, 
                      p.name as program_name, p.degree_level,
                      u.name as university_name, u.logo as university_logo
                      FROM applications a
                      JOIN students s ON a.student_id = s.id
                      JOIN programs p ON a.program_id = p.id
                      JOIN universities u ON p.university_id = u.id
                      WHERE a.counselor_id = ?
                      ORDER BY a.created_at DESC");
$stmt->execute([$_SESSION['user_id']]);
$applications = $stmt->fetchAll();

// Get counselor data
$stmt = $pdo->prepare("SELECT first_name, last_name FROM counselors WHERE id = ?");
$stmt->execute([$_SESSION['user_id']]);
$counselor = $stmt->fetch();
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <title>Applications - JV Overseas Education</title>
    <meta content="width=device-width, initial-scale=1.0" name="viewport">
    <link href="https://fonts.googleapis.com/css2?family=Jost:wght@500;600;700&family=Open+Sans:wght@400;600&display=swap" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.10.0/css/all.min.css" rel="stylesheet">
    <link href="css/style.css" rel="stylesheet">
    <style>
        .university-logo {
            height: 60px;
            object-fit: contain;
            background: white;
            padding: 5px;
            border-radius: 5px;
        }
    </style>
</head>
<body>

<?php include 'counselor-navbar.php'; ?>

<div class="container py-5">
    <div class="section-title position-relative mb-4">
        <h6 class="d-inline-block position-relative text-secondary text-uppercase pb-2">Applications</h6>
        <h1 class="display-5">Applications Managed by <?= htmlspecialchars($counselor['first_name']) ?></h1>
    </div>

    <div class="table-responsive">
        <table class="table table-bordered">
            <thead>
                <tr>
                    <th>Student</th>
                    <th>University</th>
                    <th>Program</th>
                    <th>Status</th>
                    <th>Submitted</th>
                    <th>Actions</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($applications as $app): ?>
                <tr>
                    <td><?= htmlspecialchars($app['first_name'] . ' ' . $app['last_name']) ?></td>
                    <td>
                        <div class="d-flex align-items-center">
                            <img src="<?= htmlspecialchars($app['university_logo'] ?: 'img/university-placeholder.png') ?>" 
                                 alt="<?= htmlspecialchars($app['university_name']) ?>" class="university-logo mr-2">
                            <?= htmlspecialchars($app['university_name']) ?>
                        </div>
                    </td>
                    <td><?= htmlspecialchars($app['degree_level'] . ' in ' . $app['program_name']) ?></td>
                    <td>
                        <span class="badge badge-<?= 
                            $app['application_status'] === 'accepted' ? 'success' :
                            $app['application_status'] === 'submitted' ? 'info' :
                            $app['application_status'] === 'under_review' ? 'warning' :
                            $app['application_status'] === 'rejected' ? 'danger' : 'secondary'
                        ?>"><?= ucfirst($app['application_status']) ?></span>
                    </td>
                    <td><?= $app['submission_date'] ? date('M j, Y', strtotime($app['submission_date'])) : 'Not submitted' ?></td>
                    <td>
                        <div class="btn-group">
                            <a href="counselor-application-review.php?id=<?= $app['id'] ?>" class="btn btn-sm btn-primary">Review</a>
                            <a href="counselor-messages.php?student_id=<?= $app['student_id'] ?>" class="btn btn-sm btn-outline-primary">Message</a>
                        </div>
                    </td>
                </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    </div>
</div>

<?php include 'footer.php'; ?>
<script src="https://code.jquery.com/jquery-3.4.1.min.js"></script>
<script src="https://stackpath.bootstrapcdn.com/bootstrap/4.4.1/js/bootstrap.bundle.min.js"></script>
</body>
</html>