<?php
session_start();
require_once 'config.php';

if (!isset($_SESSION['user_id']) || $_SESSION['user_type'] !== 'counselor') {
    header('Location: counselor-login.php');
    exit;
}

// Get counselor's students
$stmt = $pdo->prepare("SELECT s.*, u.email, 
                      CONCAT(c.first_name, ' ', c.last_name) as counselor_name
                      FROM students s
                      JOIN users u ON s.id = u.id
                      LEFT JOIN counselors c ON s.assigned_counselor_id = c.id
                      WHERE s.assigned_counselor_id = ?
                      ORDER BY s.last_name, s.first_name");
$stmt->execute([$_SESSION['user_id']]);
$students = $stmt->fetchAll();

// Get counselor data for page title
$stmt = $pdo->prepare("SELECT first_name, last_name FROM counselors WHERE id = ?");
$stmt->execute([$_SESSION['user_id']]);
$counselor = $stmt->fetch();
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <title>My Students - JV Overseas Education</title>
    <meta content="width=device-width, initial-scale=1.0" name="viewport">
    <link href="https://fonts.googleapis.com/css2?family=Jost:wght@500;600;700&family=Open+Sans:wght@400;600&display=swap" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.10.0/css/all.min.css" rel="stylesheet">
    <link href="css/style.css" rel="stylesheet">
</head>
<body>

<?php include 'counselor-navbar.php'; ?>

<div class="container py-5">
    <div class="section-title position-relative mb-4">
        <h6 class="d-inline-block position-relative text-secondary text-uppercase pb-2">My Students</h6>
        <h1 class="display-5">Students Assigned to <?= htmlspecialchars($counselor['first_name']) ?></h1>
    </div>

    <div class="table-responsive">
        <table class="table table-bordered">
            <thead>
                <tr>
                    <th>Name</th>
                    <th>Email</th>
                    <th>Education Level</th>
                    <th>Status</th>
                    <th>Applications</th>
                    <th>Actions</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($students as $s): ?>
                <tr>
                    <td><?= htmlspecialchars($s['first_name'] . ' ' . $s['last_name']) ?></td>
                    <td><?= htmlspecialchars($s['email']) ?></td>
                    <td><?= htmlspecialchars($s['education_level'] ?: 'Not specified') ?></td>
                    <td>
                        <?php
                        $badgeClass = 'secondary'; // default
                        if ($s['status'] === 'active') {
                            $badgeClass = 'success';
                        } elseif ($s['status'] === 'prospective') {
                            $badgeClass = 'info';
                        } elseif ($s['status'] === 'admitted') {
                            $badgeClass = 'primary';
                        } elseif ($s['status'] === 'rejected') {
                            $badgeClass = 'danger';
                        }
                        ?>
                        <span class="badge badge-<?= $badgeClass ?>"><?= ucfirst($s['status']) ?></span>
                    </td>
                    <td>
                        <?php
                        $app_count = $pdo->prepare("SELECT COUNT(*) FROM applications WHERE student_id = ?");
                        $app_count->execute([$s['id']]);
                        echo $app_count->fetchColumn();
                        ?>
                    </td>
                    <td>
                        <div class="btn-group">
                            <a href="counselor-student-profile.php?id=<?= $s['id'] ?>" class="btn btn-sm btn-primary">View</a>
                            <a href="counselor-messages.php?student_id=<?= $s['id'] ?>" class="btn btn-sm btn-outline-primary">Message</a>
                        </div>
                    </td>
                </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    </div>
</div>


<script src="https://code.jquery.com/jquery-3.4.1.min.js"></script>
<script src="https://stackpath.bootstrapcdn.com/bootstrap/4.4.1/js/bootstrap.bundle.min.js"></script>
</body>
</html>