<?php
// setup-admin.php - Run this once to create the initial admin

$host = 'localhost';
$dbname = 'jv_overseas';
$username = 'root';
$password = '';

try {
    $pdo = new PDO("mysql:host=$host;dbname=$dbname;charset=utf8", $username, $password);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
    
    // Admin credentials
    $email = 'admin@jvoverseas.com';
    $password = 'Introduction890@';
    $firstName = 'System';
    $lastName = 'Administrator';
    
    // Hash the password
    $passwordHash = password_hash($password, PASSWORD_DEFAULT);
    
    // Start transaction
    $pdo->beginTransaction();
    
    // Create user
    $stmt = $pdo->prepare("INSERT INTO users (email, password_hash, user_type, is_active, created_at, updated_at) 
                          VALUES (?, ?, 'admin', 1, NOW(), NOW())");
    $stmt->execute([$email, $passwordHash]);
    $userId = $pdo->lastInsertId();
    
    // Create admin profile
    $stmt = $pdo->prepare("INSERT INTO admins (
        id, first_name, last_name, department, permissions, created_at, updated_at
    ) VALUES (?, ?, ?, 'administration', '[]', NOW(), NOW())");
    $stmt->execute([$userId, $firstName, $lastName]);
    
    // Commit transaction
    $pdo->commit();
    
    echo "Admin account created successfully!\n";
    echo "Email: $email\n";
    echo "Password: $password\n";
    echo "Please delete this setup script for security reasons!";
    
} catch(Exception $e) {
    $pdo->rollback();
    echo "Error creating admin account: " . $e->getMessage();
}
?>