<?php
// Start session for navbar
session_start();
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <title>JV Overseas Education - Study Abroad Consultants</title>
    <meta content="width=device-width, initial-scale=1.0" name="viewport">
    <link rel="preconnect" href="https://fonts.gstatic.com">
    <link href="https://fonts.googleapis.com/css2?family=Jost:wght@500;600;700&family=Open+Sans:wght@400;600&display=swap" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.10.0/css/all.min.css" rel="stylesheet">
    <link href="lib/owlcarousel/assets/owl.carousel.min.css" rel="stylesheet">
    <link href="css/style.css" rel="stylesheet">
    <style>
        /* Fix for white text on white background */
        .bg-image {
            background: linear-gradient(rgba(63, 183, 254, 0.9), rgba(63, 183, 254, 0.9)), url('img/feature-bg.jpg') center center no-repeat;
            background-size: cover;
        }
        
        .bg-registration {
            background: linear-gradient(rgba(63, 183, 254, 0.8), rgba(63, 183, 254, 0.8)), url('img/registration-bg.jpg') center center no-repeat;
            background-size: cover;
        }
        
        /* Ensure text is visible */
        .bg-image * {
            color: #333 !important;
        }
        
        .bg-image .text-white {
            color: #333 !important;
        }
        
        .bg-image .btn {
            color: #333 !important;
        }
        
        .bg-registration * {
            color: #333 !important;
        }
        
        .bg-registration .text-white {
            color: #333 !important;
        }
    </style>
</head>
<body>

<?php include 'navbar.php'; ?>

<!-- Header Start -->
<div class="jumbotron jumbotron-fluid position-relative overlay-bottom" style="margin-bottom: 90px;">
    <div class="container text-center my-5 py-5">
        <h1 class="text-white mt-4 mb-4">Uganda's Trusted Study Abroad Consultants</h1>
        <h1 class="text-white display-1 mb-5">Your Global Education Journey Starts Here</h1>
        <div class="mx-auto mb-5" style="width: 100%; max-width: 600px;">
            <div class="input-group">
                <input type="text" class="form-control border-light" style="padding: 30px 25px;" placeholder="Search courses or universities...">
                <div class="input-group-append">
                    <button class="btn btn-secondary px-4 px-lg-5">Search</button>
                </div>
            </div>
        </div>
        <a href="apply.php" class="btn btn-outline-primary mr-3 py-3 px-5">Free Consultation</a>
        <a href="about.php" class="btn btn-primary py-3 px-5">Learn More</a>
    </div>
</div>
<!-- Header End -->

<!-- About Start -->
<div class="container-fluid py-5">
    <div class="container py-5">
        <div class="row">
            <div class="col-lg-5 mb-5 mb-lg-0" style="min-height: 500px;">
                <div class="position-relative h-100">
                    <img class="position-absolute w-100 h-100" src="img/about-us.jpg" style="object-fit: cover;" alt="About JV Overseas Education">
                    <button type="button" class="btn btn-play" data-toggle="modal"
                        data-src="https://www.youtube.com/embed/DWRcNpR6Kdc" data-target="#videoModal">
                        <span></span>
                    </button>
                </div>
            </div>
            <div class="col-lg-7">
                <div class="section-title position-relative mb-4">
                    <h6 class="d-inline-block position-relative text-secondary text-uppercase pb-2">About Us</h6>
                    <h1 class="display-4">Uganda's Premier Education Consultants</h1>
                </div>
                <p class="mb-5">JV Overseas Education is a leading educational consultancy helping students from Uganda access higher education opportunities worldwide. With over a decade of experience, we have successfully placed thousands of students in top universities across the globe.</p>
                <div class="row pt-3 mx-0">
                    <div class="col-3 px-0">
                        <div class="bg-primary text-center p-4">
                            <h1 class="text-white" data-toggle="counter-up">5,000</h1>
                            <h6 class="text-uppercase text-white">Students Placed</h6>
                        </div>
                    </div>
                    <div class="col-3 px-0">
                        <div class="bg-secondary text-center p-4">
                            <h1 class="text-white" data-toggle="counter-up">200</h1>
                            <h6 class="text-uppercase text-white">Partner Universities</h6>
                        </div>
                    </div>
                    <div class="col-3 px-0">
                        <div class="bg-primary text-center p-4">
                            <h1 class="text-white" data-toggle="counter-up">$15M</h1>
                            <h6 class="text-uppercase text-white">Scholarships Secured</h6>
                        </div>
                    </div>
                    <div class="col-3 px-0">
                        <div class="bg-secondary text-center p-4">
                            <h1 class="text-white" data-toggle="counter-up">25</h1>
                            <h6 class="text-uppercase text-white">Expert Counselors</h6>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<!-- About End -->

<!-- Feature Start -->
<div class="container-fluid bg-image py-5" style="margin: 90px 0;">
    <div class="container py-5">
        <div class="row align-items-center">
            <div class="col-lg-5">
                <h1 class="text-dark mb-4">Why Choose JV Overseas Education?</h1>
                <p class="mb-4 text-dark">We provide comprehensive support throughout your study abroad journey, from university selection to visa processing and pre-departure orientation.</p>
                <ul class="list-inline text-dark m-0">
                    <li class="py-2"><i class="fa fa-check text-primary mr-3"></i>100% Visa Success Rate</li>
                    <li class="py-2"><i class="fa fa-check text-primary mr-3"></i>Dedicated Counselor</li>
                    <li class="py-2"><i class="fa fa-check text-primary mr-3"></i>24/7 Support</li>
                    <li class="py-2"><i class="fa fa-check text-primary mr-3"></i>No Processing Fees</li>
                </ul>
            </div>
            <div class="col-lg-7 pt-5 pt-lg-0">
                <div class="row">
                    <div class="col-6">
                        <div class="bg-white text-center rounded-circle p-4">
                            <i class="fa fa-2x fa-graduation-cap text-primary mb-2"></i>
                            <h6>Education Counseling</h6>
                        </div>
                    </div>
                    <div class="col-6">
                        <div class="bg-white text-center rounded-circle p-4">
                            <i class="fa fa-2x fa-university text-primary mb-2"></i>
                            <h6>University Admission</h6>
                        </div>
                    </div>
                    <div class="col-6">
                        <div class="bg-white text-center rounded-circle p-4">
                            <i class="fa fa-2x fa-passport text-primary mb-2"></i>
                            <h6>Visa Assistance</h6>
                        </div>
                    </div>
                    <div class="col-6">
                        <div class="bg-white text-center rounded-circle p-4">
                            <i class="fa fa-2x fa-home text-primary mb-2"></i>
                            <h6>Accommodation</h6>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<!-- Feature End -->

<!-- Courses Start -->
<div class="container-fluid py-5">
    <div class="container py-5">
        <div class="text-center mb-5">
            <h5 class="text-primary text-uppercase mb-3" style="letter-spacing: 5px;">Popular Programs</h5>
            <h1>Featured Academic Programs</h1>
        </div>
        <div class="row">
            <div class="col-lg-4 col-md-6 mb-5">
                <div class="courses-item">
                    <div class="position-relative">
                        <img class="img-fluid" src="img/course-1.jpg" alt="">
                        <div class="courses-overlay">
                            <a class="btn btn-outline-primary border-2" href="program-profile.php?id=1">View Program</a>
                        </div>
                    </div>
                    <div class="bg-white p-4">
                        <div class="row">
                            <div class="col-8">
                                <div class="d-flex align-items-center">
                                    <img src="img/university-1.jpg" alt="University" class="university-logo">
                                </div>
                            </div>
                            <div class="col-4 text-right">
                                <span class="badge badge-primary">Bachelors</span>
                            </div>
                        </div>
                        <h5 class="mt-3">Computer Science</h5>
                        <div class="d-flex justify-content-between">
                            <div class="d-flex align-items-center">
                                <i class="fa fa-map-marker-alt text-primary mr-2"></i>
                                <small>USA</small>
                            </div>
                            <div class="d-flex align-items-center">
                                <i class="fa fa-money-check text-primary mr-2"></i>
                                <small>$25,000/yr</small>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-lg-4 col-md-6 mb-5">
                <div class="courses-item">
                    <div class="position-relative">
                        <img class="img-fluid" src="img/course-2.jpg" alt="">
                        <div class="courses-overlay">
                            <a class="btn btn-outline-primary border-2" href="program-profile.php?id=2">View Program</a>
                        </div>
                    </div>
                    <div class="bg-white p-4">
                        <div class="row">
                            <div class="col-8">
                                <div class="d-flex align-items-center">
                                    <img src="img/university-2.jpg" alt="University" class="university-logo">
                                </div>
                            </div>
                            <div class="col-4 text-right">
                                <span class="badge badge-primary">Masters</span>
                            </div>
                        </div>
                        <h5 class="mt-3">Business Administration</h5>
                        <div class="d-flex justify-content-between">
                            <div class="d-flex align-items-center">
                                <i class="fa fa-map-marker-alt text-primary mr-2"></i>
                                <small>UK</small>
                            </div>
                            <div class="d-flex align-items-center">
                                <i class="fa fa-money-check text-primary mr-2"></i>
                                <small>$28,000/yr</small>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-lg-4 col-md-6 mb-5">
                <div class="courses-item">
                    <div class="position-relative">
                        <img class="img-fluid" src="img/course-3.jpg" alt="">
                        <div class="courses-overlay">
                            <a class="btn btn-outline-primary border-2" href="program-profile.php?id=3">View Program</a>
                        </div>
                    </div>
                    <div class="bg-white p-4">
                        <div class="row">
                            <div class="col-8">
                                <div class="d-flex align-items-center">
                                    <img src="img/university-3.jpg" alt="University" class="university-logo">
                                </div>
                            </div>
                            <div class="col-4 text-right">
                                <span class="badge badge-primary">PhD</span>
                            </div>
                        </div>
                        <h5 class="mt-3">Engineering</h5>
                        <div class="d-flex justify-content-between">
                            <div class="d-flex align-items-center">
                                <i class="fa fa-map-marker-alt text-primary mr-2"></i>
                                <small>Canada</small>
                            </div>
                            <div class="d-flex align-items-center">
                                <i class="fa fa-money-check text-primary mr-2"></i>
                                <small>$32,000/yr</small>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<!-- Courses End -->

<!-- Registration Start -->
<div class="container-fluid bg-registration py-5" style="margin: 90px 0;">
    <div class="container py-5">
        <div class="row align-items-center">
            <div class="col-lg-7 mb-5 mb-lg-0">
                <div class="mb-4">
                    <h6 class="text-primary text-uppercase" style="letter-spacing: 5px;">Get In Touch</h6>
                    <h1 class="text-dark">Get 20% Off For Online Registration</h1>
                </div>
                <p class="text-dark">Register for a free consultation today and receive personalized guidance on your study abroad journey from our expert counselors.</p>
                <ul class="list-inline text-dark m-0">
                    <li class="py-2"><i class="fa fa-check text-primary mr-3"></i>Free Consultation</li>
                    <li class="py-2"><i class="fa fa-check text-primary mr-3"></i>University Selection</li>
                    <li class="py-2"><i class="fa fa-check text-primary mr-3"></i>Application Assistance</li>
                </ul>
            </div>
            <div class="col-lg-5">
                <div class="card border-0">
                    <div class="card-header bg-light text-center p-4">
                        <h1 class="m-0">Get Free Consultation</h1>
                    </div>
                    <div class="card-body rounded-bottom bg-primary p-5">
                        <form action="apply.php">
                            <div class="form-group">
                                <input type="text" class="form-control border-0 p-4" placeholder="Your Name" required="required" />
                            </div>
                            <div class="form-group">
                                <input type="email" class="form-control border-0 p-4" placeholder="Your Email" required="required" />
                            </div>
                            <div class="form-group">
                                <select class="custom-select border-0 px-4" style="height: 47px;">
                                    <option selected>Choose Destination</option>
                                    <option value="1">USA</option>
                                    <option value="2">UK</option>
                                    <option value="3">Canada</option>
                                    <option value="4">Australia</option>
                                    <option value="5">Germany</option>
                                </select>
                            </div>
                            <div>
                                <button class="btn btn-dark btn-block border-0 py-3" type="submit">Get Consultation</button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<!-- Registration End -->

<!-- Universities Start -->
<div class="container-fluid py-5">
    <div class="container py-5">
        <div class="text-center mb-5">
            <h5 class="text-primary text-uppercase mb-3" style="letter-spacing: 5px;">Partner Universities</h5>
            <h1>Our Global University Partners</h1>
        </div>
        <div class="row">
            <div class="col-lg-2 col-md-4 col-sm-6 mb-4">
                <div class="text-center">
                    <img class="img-fluid" src="img/university-1.jpg" alt="Harvard University" style="height: 60px; object-fit: contain;">
                    <h6 class="mt-3">Harvard University</h6>
                    <p class="text-muted">USA</p>
                </div>
            </div>
            <div class="col-lg-2 col-md-4 col-sm-6 mb-4">
                <div class="text-center">
                    <img class="img-fluid" src="img/university-2.jpg" alt="Oxford University" style="height: 60px; object-fit: contain;">
                    <h6 class="mt-3">Oxford University</h6>
                    <p class="text-muted">UK</p>
                </div>
            </div>
            <div class="col-lg-2 col-md-4 col-sm-6 mb-4">
                <div class="text-center">
                    <img class="img-fluid" src="img/university-3.jpg" alt="University of Toronto" style="height: 60px; object-fit: contain;">
                    <h6 class="mt-3">University of Toronto</h6>
                    <p class="text-muted">Canada</p>
                </div>
            </div>
            <div class="col-lg-2 col-md-4 col-sm-6 mb-4">
                <div class="text-center">
                    <img class="img-fluid" src="img/university-4.jpg" alt="University of Melbourne" style="height: 60px; object-fit: contain;">
                    <h6 class="mt-3">University of Melbourne</h6>
                    <p class="text-muted">Australia</p>
                </div>
            </div>
            <div class="col-lg-2 col-md-4 col-sm-6 mb-4">
                <div class="text-center">
                    <img class="img-fluid" src="img/university-5.jpg" alt="ETH Zurich" style="height: 60px; object-fit: contain;">
                    <h6 class="mt-3">ETH Zurich</h6>
                    <p class="text-muted">Switzerland</p>
                </div>
            </div>
            <div class="col-lg-2 col-md-4 col-sm-6 mb-4">
                <div class="text-center">
                    <img class="img-fluid" src="img/university-6.jpg" alt="National University of Singapore" style="height: 60px; object-fit: contain;">
                    <h6 class="mt-3">NUS</h6>
                    <p class="text-muted">Singapore</p>
                </div>
            </div>
        </div>
    </div>
</div>
<!-- Universities End -->

<!-- Footer Start -->
<div class="container-fluid position-relative overlay-top bg-dark text-white-50 py-5" style="margin-top: 90px;">
    <div class="container mt-5 pt-5">
        <div class="row">
            <div class="col-md-6 mb-5">
                <a href="index.php" class="navbar-brand">
                    <img src="img/jhoverseas.jpg" alt="JV Overseas Logo" style="height: 50px;">
                </a>
                <p class="m-0">JV Overseas Education Uganda is a leading educational consultancy helping students access higher education opportunities worldwide.</p>
            </div>
            <div class="col-md-6 mb-5">
                <h3 class="text-white mb-4">Quick Links</h3>
                <div class="d-flex flex-column justify-content-start">
                    <a class="text-white-50 mb-2" href="index.php"><i class="fa fa-angle-right mr-2"></i>Home</a>
                    <a class="text-white-50 mb-2" href="about.php"><i class="fa fa-angle-right mr-2"></i>About Us</a>
                    <a class="text-white-50 mb-2" href="services.php"><i class="fa fa-angle-right mr-2"></i>Services</a>
                    <a class="text-white-50 mb-2" href="universities.php"><i class="fa fa-angle-right mr-2"></i>Universities</a>
                    <a class="text-white-50 mb-2" href="apply.php"><i class="fa fa-angle-right mr-2"></i>Free Consultation</a>
                    <a class="text-white-50 mb-2" href="contact.php"><i class="fa fa-angle-right mr-2"></i>Contact Us</a>
                </div>
            </div>
        </div>
        <div class="row">
            <div class="col-md-6 mb-5">
                <h3 class="text-white mb-4">Get In Touch</h3>
                <p class="m-0"><i class="fa fa-map-marker-alt mr-2"></i>Kampala, Uganda</p>
                <p class="m-0"><i class="fa fa-phone-alt mr-2"></i><a href="tel:+256788289235" class="text-white-50">+256 788 289 235</a></p>
                <p class="m-0"><i class="fa fa-envelope mr-2"></i><a href="mailto:info@jvoverseas.com" class="text-white-50">info@jvoverseas.com</a></p>
                <div class="d-flex flex-column justify-content-start">
                    <div class="d-flex align-items-center mt-2">
                        <a class="text-white-50 mr-2" href="#"><i class="fab fa-twitter"></i></a>
                        <a class="text-white-50 mr-2" href="#"><i class="fab fa-facebook-f"></i></a>
                        <a class="text-white-50 mr-2" href="#"><i class="fab fa-linkedin-in"></i></a>
                        <a class="text-white-50 mr-2" href="#"><i class="fab fa-instagram"></i></a>
                    </div>
                </div>
            </div>
            <div class="col-md-6 mb-5">
                <h3 class="text-white mb-4">Newsletter</h3>
                <p>Stay updated with our latest news and education opportunities.</p>
                <form action="newsletter-subscribe.php" method="POST">
                    <div class="form-inline">
                        <div class="input-group">
                            <input type="email" class="form-control" name="email" placeholder="Your Email" required>
                            <div class="input-group-append">
                                <button class="btn btn-primary" type="submit">Subscribe</button>
                            </div>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
<!-- Footer End -->

<!-- Back to Top -->
<a href="#" class="btn btn-lg btn-primary rounded-0 btn-lg-square back-to-top"><i class="fa fa-angle-double-up"></i></a>

<!-- JavaScript Libraries -->
<script src="https://code.jquery.com/jquery-3.4.1.min.js"></script>
<script src="https://stackpath.bootstrapcdn.com/bootstrap/4.4.1/js/bootstrap.bundle.min.js"></script>
<script src="lib/easing/easing.min.js"></script>
<script src="lib/waypoints/waypoints.min.js"></script>
<script src="lib/counterup/counterup.min.js"></script>
<script src="lib/owlcarousel/owl.carousel.min.js"></script>
<script src="mail/jqBootstrapValidation.min.js"></script>
<script src="mail/contact.js"></script>
<script src="js/main.js"></script>

<script>
// Set current year in footer
document.getElementById('year')?.textContent = new Date().getFullYear();
</script>
<!-- Video Modal -->
<div class="modal fade" id="videoModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-body">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>        
                <!-- 16:9 aspect ratio -->
                <div class="embed-responsive embed-responsive-16by9">
                    <iframe class="embed-responsive-item" src="" id="video" allowscriptaccess="always" allow="autoplay"></iframe>
                </div>
            </div>
        </div>
    </div>
</div>

<script src="https://code.jquery.com/jquery-3.4.1.min.js"></script>
<script src="https://stackpath.bootstrapcdn.com/bootstrap/4.4.1/js/bootstrap.bundle.min.js"></script>
<script src="lib/easing/easing.min.js"></script>
<script src="lib/waypoints/waypoints.min.js"></script>
<script src="lib/counterup/counterup.min.js"></script>
<script src="lib/owlcarousel/owl.carousel.min.js"></script>
<script src="mail/jqBootstrapValidation.min.js"></script>
<script src="mail/contact.js"></script>
<script src="js/main.js"></script>
<script>
    // Video modal
    $(document).ready(function () {
        var $videoSrc;
        $('.btn-play').click(function () {
            $videoSrc = $(this).data("src");
        });
        console.log($videoSrc);

        $('#videoModal').on('shown.bs.modal', function (e) {
            $("#video").attr('src', $videoSrc + "?autoplay=1&amp;modestbranding=1&amp;showinfo=0");
        })

        $('#videoModal').on('hide.bs.modal', function (e) {
            $("#video").attr('src', $videoSrc);
        })
    });
</script>
</body>
</html>