<?php
session_start();

// Database connection
$host = 'localhost';
$dbname = 'jv_overseas';
$username = 'root';
$password = '';

try {
    $pdo = new PDO("mysql:host=$host;dbname=$dbname;charset=utf8", $username, $password);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
} catch(PDOException $e) {
    die("Connection failed: " . $e->getMessage());
}

// Get notification count for logged in students
$notification_count = 0;
if (isset($_SESSION['user_id']) && $_SESSION['user_type'] === 'student') {
    $stmt = $pdo->prepare("SELECT COUNT(*) FROM notifications WHERE user_id = ? AND is_read = 0");
    $stmt->execute([$_SESSION['user_id']]);
    $notification_count = $stmt->fetchColumn();
}
?>

<!-- Navbar Start -->
<nav class="navbar navbar-expand-lg bg-white navbar-light py-3 px-lg-5">
    <a href="index.php" class="navbar-brand ml-lg-3">
        <img src="img/jhoverseas.jpg" alt="JV Overseas Education" style="height: 60px;">
    </a>
    <button type="button" class="navbar-toggler" data-toggle="collapse" data-target="#navbarCollapse">
        <span class="navbar-toggler-icon"></span>
    </button>
    <div class="collapse navbar-collapse justify-content-between px-lg-3" id="navbarCollapse">
        <div class="navbar-nav mx-auto py-0">
            <a href="index.php" class="nav-item nav-link">Home</a>
            <a href="about.php" class="nav-item nav-link">About</a>
            <a href="services.php" class="nav-item nav-link">Services</a>
            <a href="destinations.php" class="nav-item nav-link">Destinations</a>
            <a href="universities.php" class="nav-item nav-link">Universities</a>
            <a href="blog.php" class="nav-item nav-link">Blog</a>
            <a href="contact.php" class="nav-item nav-link">Contact</a>
        </div>
        
        <?php if (isset($_SESSION['user_id']) && $_SESSION['user_type'] === 'student'): ?>
        <!-- Student Dashboard Navigation -->
        <div class="navbar-nav ml-auto py-0">
            <a href="student-dashboard.php" class="nav-item nav-link">Dashboard</a>
            <a href="student-profile.php" class="nav-item nav-link">Profile</a>
            <a href="student-messages.php" class="nav-item nav-link position-relative">
                Messages
                <?php if ($notification_count > 0): ?>
                <span class="badge notification-badge bg-primary"><?= $notification_count ?></span>
                <?php endif; ?>
            </a>
            <a href="student-dashboard.php?logout=1" class="nav-item nav-link">Logout</a>
        </div>
        <?php else: ?>
        <!-- Login/Register for non-logged in users -->
        <div class="navbar-nav ml-auto py-0">
            <a href="student-login.php" class="btn btn-outline-primary">Login</a>
            <a href="student-register.php" class="btn btn-primary">Register</a>
            <a href="apply.php" class="btn btn-primary py-2 px-4 d-none d-lg-block">Free Consultation</a>
        </div>
        <?php endif; ?>
    </div>
</nav>
<!-- Navbar End -->