<?php
require_once '../../config.php';
check_login();

if (!isset($_GET['id'])) {
    header('Location: /dashboard/');
    exit;
}

$invoice_id = (int)$_GET['id'];
$invoice = get_invoice_details($invoice_id);

// Check if user has permission to view this invoice
if (!has_invoice_access($_SESSION['user']['id'], $invoice_id)) {
    header('Location: /dashboard/');
    exit;
}

// Generate PDF
require_once '../../lib/tcpdf/tcpdf.php';

$pdf = new TCPDF(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);

// Set document information
$pdf->SetCreator('JV Overseas Education');
$pdf->SetAuthor('JV Overseas Education');
$pdf->SetTitle('Invoice - ' . $invoice['invoice_number']);
$pdf->SetSubject('Invoice');
$pdf->SetKeywords('Invoice, Payment, Receipt');

// Set margins
$pdf->SetMargins(15, 15, 15);
$pdf->SetHeaderMargin(10);
$pdf->SetFooterMargin(10);

// Add a page
$pdf->AddPage();

// Add logo
$pdf->Image('../../img/logo.png', 15, 10, 40, '', 'PNG', '', 'T', false, 300, '', false, false, 0, false, false, false);

// Invoice header
$pdf->SetFont('helvetica', 'B', 16);
$pdf->Cell(0, 10, 'INVOICE', 0, 1, 'R');
$pdf->SetFont('helvetica', '', 10);
$pdf->Cell(0, 5, 'Invoice #: ' . $invoice['invoice_number'], 0, 1, 'R');
$pdf->Cell(0, 5, 'Date: ' . format_date($invoice['created_at']), 0, 1, 'R');
$pdf->Cell(0, 5, 'Due Date: ' . format_date($invoice['due_date']), 0, 1, 'R');
$pdf->Ln(10);

// Billing information
$pdf->SetFont('helvetica', 'B', 12);
$pdf->Cell(0, 6, 'Billed To:', 0, 1);
$pdf->SetFont('helvetica', '', 10);
$pdf->Cell(0, 6, $invoice['student_name'], 0, 1);
$pdf->Cell(0, 6, $invoice['student_email'], 0, 1);
$pdf->Cell(0, 6, $invoice['student_phone'], 0, 1);
$pdf->Ln(10);

// Invoice items
$pdf->SetFont('helvetica', 'B', 12);
$pdf->Cell(100, 6, 'Description', 1, 0);
$pdf->Cell(30, 6, 'Amount', 1, 1, 'R');

$pdf->SetFont('helvetica', '', 10);
$pdf->Cell(100, 6, $invoice['description'], 1, 0);
$pdf->Cell(30, 6, number_format($invoice['amount'], 2) . ' ' . $invoice['currency'], 1, 1, 'R');

// Totals
$pdf->SetFont('helvetica', 'B', 10);
$pdf->Cell(100, 6, 'Total Due:', 1, 0, 'R');
$pdf->Cell(30, 6, number_format($invoice['amount'], 2) . ' ' . $invoice['currency'], 1, 1, 'R');

// Payment status
$pdf->Ln(10);
$pdf->SetFont('helvetica', 'B', 12);
$pdf->Cell(0, 6, 'Payment Status: ' . ucfirst($invoice['status']), 0, 1);

if ($invoice['status'] == 'paid') {
    $pdf->SetFont('helvetica', '', 10);
    $pdf->Cell(0, 6, 'Payment Date: ' . format_date($invoice['payment_date']), 0, 1);
    $pdf->Cell(0, 6, 'Payment Method: ' . ucfirst(str_replace('_', ' ', $invoice['payment_method'])), 0, 1);
    $pdf->Cell(0, 6, 'Transaction ID: ' . $invoice['transaction_id'], 0, 1);
}

// Payment instructions if unpaid
if ($invoice['status'] == 'unpaid') {
    $pdf->Ln(5);
    $pdf->SetFont('helvetica', 'B', 12);
    $pdf->Cell(0, 6, 'Payment Instructions:', 0, 1);
    $pdf->SetFont('helvetica', '', 10);
    $pdf->MultiCell(0, 6, "Please make payment to:\nBank: Centenary Bank\nAccount Name: JV Overseas Education\nAccount Number: 3100000000\nBranch: Kampala Road\nReference: Invoice #" . $invoice['invoice_number']);
}

// Footer
$pdf->Ln(15);
$pdf->SetFont('helvetica', 'I', 8);
$pdf->Cell(0, 5, 'Thank you for choosing JV Overseas Education', 0, 1, 'C');
$pdf->Cell(0, 5, 'For any inquiries, please contact info@jvoverseas.com or call +256 788 289 235', 0, 1, 'C');

// Output PDF
$pdf->Output('invoice_' . $invoice['invoice_number'] . '.pdf', 'I');