<?php
require_once __DIR__ . '/../../includes/dashboard-config.php';

// For role-specific pages, add:
checkRoleAccess(ROLE_STUDENT); // or ROLE_COUNSELOR or ROLE_ADMIN
require_once '../../includes/config.php';
require_once '../../includes/auth.php';
require_once '../../includes/dashboard-config.php';

// Check if user is logged in and is an admin
if (!isLoggedIn() || $_SESSION['user_type'] != 'admin') {
    header('Location: ../login.php');
    exit();
}

// Get admin data
$admin_id = $_SESSION['user_id'];
$stmt = $pdo->prepare("SELECT * FROM admins WHERE id = ?");
$stmt->execute([$admin_id]);
$admin = $stmt->fetch(PDO::FETCH_ASSOC);

// Get stats for dashboard
$students_count = $pdo->query("SELECT COUNT(*) FROM students")->fetchColumn();
$active_applications = $pdo->query("SELECT COUNT(*) FROM applications WHERE status NOT IN ('Completed', 'Rejected')")->fetchColumn();
$pending_documents = $pdo->query("SELECT COUNT(*) FROM student_documents WHERE status = 'Pending'")->fetchColumn();
$recent_applications = $pdo->query("SELECT a.id, s.first_name, s.last_name, a.university_id, u.name as university_name, a.status 
                                   FROM applications a 
                                   JOIN students s ON a.student_id = s.id 
                                   JOIN universities u ON a.university_id = u.id 
                                   ORDER BY a.created_at DESC LIMIT 5")->fetchAll(PDO::FETCH_ASSOC);
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <title>JV Overseas Education - Admin Dashboard</title>
    <meta content="width=device-width, initial-scale=1.0" name="viewport">
    <!-- Include your existing CSS files -->
    <link href="../../css/style.css" rel="stylesheet">
    <!-- Dashboard-specific CSS -->
    <link href="../../css/dashboard.css" rel="stylesheet">
    <style>
        /* Admin dashboard specific styles */
        .dashboard-header {
            background: linear-gradient(rgba(40, 58, 90, 0.9), rgba(40, 58, 90, 0.9));
            color: white;
        }
        .stat-card {
            transition: all 0.3s;
            border-left: 4px solid #3fb7fe;
        }
        .stat-card:hover {
            transform: translateY(-5px);
            box-shadow: 0 10px 20px rgba(0,0,0,0.1);
        }
        .application-row:hover {
            background-color: #f8f9fa;
        }
    </style>
</head>
<body>
    <!-- Dashboard Header -->
    <header class="dashboard-header py-3">
        <div class="container">
            <div class="d-flex justify-content-between align-items-center">
                <div class="d-flex align-items-center">
                    <img src="../../img/logo-white.png" alt="JV Overseas" style="height: 40px;">
                    <h4 class="mb-0 ml-3">Admin Dashboard</h4>
                </div>
                <div class="dropdown">
                    <button class="btn btn-light dropdown-toggle" type="button" id="profileDropdown" data-toggle="dropdown">
                        <img src="<?= !empty($admin['profile_photo']) ? '../../uploads/'.$admin['profile_photo'] : '../../img/default-profile.jpg' ?>" 
                             class="rounded-circle mr-2" width="30" height="30">
                        <?= htmlspecialchars($admin['first_name']) ?>
                    </button>
                    <div class="dropdown-menu dropdown-menu-right">
                        <a class="dropdown-item" href="profile.php"><i class="fas fa-user mr-2"></i>Profile</a>
                        <a class="dropdown-item" href="../logout.php"><i class="fas fa-sign-out-alt mr-2"></i>Logout</a>
                    </div>
                </div>
            </div>
        </div>
    </header>

    <!-- Dashboard Navigation -->
    <nav class="navbar navbar-expand-lg navbar-light bg-white shadow-sm">
        <div class="container">
            <button class="navbar-toggler" type="button" data-toggle="collapse" data-target="#dashboardNav">
                <span class="navbar-toggler-icon"></span>
            </button>
            <div class="collapse navbar-collapse" id="dashboardNav">
                <ul class="navbar-nav">
                    <li class="nav-item active">
                        <a class="nav-link" href="index.php"><i class="fas fa-home mr-1"></i> Dashboard</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="students.php"><i class="fas fa-users mr-1"></i> Students</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="applications.php"><i class="fas fa-file-alt mr-1"></i> Applications</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="documents.php"><i class="fas fa-file-upload mr-1"></i> Documents</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="universities.php"><i class="fas fa-university mr-1"></i> Universities</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="reports.php"><i class="fas fa-chart-bar mr-1"></i> Reports</a>
                    </li>
                </ul>
            </div>
        </div>
    </nav>

    <!-- Main Dashboard Content -->
    <div class="container py-5">
        <!-- Stats Cards -->
        <div class="row mb-4">
            <div class="col-md-4 mb-4">
                <div class="card stat-card h-100">
                    <div class="card-body">
                        <div class="d-flex justify-content-between align-items-center">
                            <div>
                                <h6 class="text-muted mb-2">Total Students</h6>
                                <h3 class="mb-0"><?= number_format($students_count) ?></h3>
                            </div>
                            <div class="bg-primary rounded p-3">
                                <i class="fas fa-users fa-2x text-white"></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-md-4 mb-4">
                <div class="card stat-card h-100">
                    <div class="card-body">
                        <div class="d-flex justify-content-between align-items-center">
                            <div>
                                <h6 class="text-muted mb-2">Active Applications</h6>
                                <h3 class="mb-0"><?= number_format($active_applications) ?></h3>
                            </div>
                            <div class="bg-warning rounded p-3">
                                <i class="fas fa-file-alt fa-2x text-white"></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-md-4 mb-4">
                <div class="card stat-card h-100">
                    <div class="card-body">
                        <div class="d-flex justify-content-between align-items-center">
                            <div>
                                <h6 class="text-muted mb-2">Pending Documents</h6>
                                <h3 class="mb-0"><?= number_format($pending_documents) ?></h3>
                            </div>
                            <div class="bg-danger rounded p-3">
                                <i class="fas fa-file-upload fa-2x text-white"></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Recent Applications -->
        <div class="row">
            <div class="col-lg-8">
                <div class="card shadow-sm mb-4">
                    <div class="card-body">
                        <div class="d-flex justify-content-between align-items-center mb-4">
                            <h4 class="mb-0">Recent Applications</h4>
                            <a href="applications.php" class="btn btn-sm btn-primary">View All</a>
                        </div>
                        <div class="table-responsive">
                            <table class="table table-hover">
                                <thead class="thead-light">
                                    <tr>
                                        <th>Student</th>
                                        <th>University</th>
                                        <th>Status</th>
                                        <th>Action</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php foreach ($recent_applications as $app): ?>
                                        <tr class="application-row">
                                            <td><?= htmlspecialchars($app['first_name'].' '.$app['last_name']) ?></td>
                                            <td><?= htmlspecialchars($app['university_name']) ?></td>
                                            <td>
                                                <span class="badge badge-<?= 
                                                    $app['status'] == 'Admitted' ? 'success' : 
                                                    ($app['status'] == 'Rejected' ? 'danger' : 'warning') ?>">
                                                    <?= htmlspecialchars($app['status']) ?>
                                                </span>
                                            </td>
                                            <td>
                                                <a href="applications.php?action=view&id=<?= $app['id'] ?>" class="btn btn-sm btn-outline-primary">View</a>
                                            </td>
                                        </tr>
                                    <?php endforeach; ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Quick Actions -->
            <div class="col-lg-4">
                <div class="card shadow-sm mb-4">
                    <div class="card-body">
                        <h4 class="card-title mb-4">Quick Actions</h4>
                        <div class="list-group">
                            <a href="students.php?action=add" class="list-group-item list-group-item-action d-flex align-items-center">
                                <i class="fas fa-user-plus mr-3 text-primary"></i>
                                Add New Student
                            </a>
                            <a href="applications.php?action=create" class="list-group-item list-group-item-action d-flex align-items-center">
                                <i class="fas fa-file-import mr-3 text-primary"></i>
                                Create Application
                            </a>
                            <a href="documents.php?filter=pending" class="list-group-item list-group-item-action d-flex align-items-center">
                                <i class="fas fa-file-signature mr-3 text-primary"></i>
                                Review Documents
                            </a>
                            <a href="universities.php?action=add" class="list-group-item list-group-item-action d-flex align-items-center">
                                <i class="fas fa-university mr-3 text-primary"></i>
                                Add University
                            </a>
                            <a href="reports.php" class="list-group-item list-group-item-action d-flex align-items-center">
                                <i class="fas fa-chart-pie mr-3 text-primary"></i>
                                Generate Reports
                            </a>
                        </div>
                    </div>
                </div>

                <!-- Recent Activity -->
                <div class="card shadow-sm">
                    <div class="card-body">
                        <h4 class="card-title mb-4">Recent Activity</h4>
                        <div class="activity-feed">
                            <?php
                            $activities = $pdo->query("SELECT a.*, u.first_name, u.last_name 
                                                      FROM activities a 
                                                      LEFT JOIN admins u ON a.user_id = u.id 
                                                      ORDER BY a.created_at DESC LIMIT 5")
                                             ->fetchAll(PDO::FETCH_ASSOC);
                            
                            foreach ($activities as $activity): ?>
                                <div class="feed-item mb-3">
                                    <div class="d-flex justify-content-between">
                                        <small class="text-muted"><?= date('M j, g:i a', strtotime($activity['created_at'])) ?></small>
                                        <small class="text-muted"><?= htmlspecialchars($activity['first_name'].' '.$activity['last_name']) ?></small>
                                    </div>
                                    <p class="mb-1"><?= htmlspecialchars($activity['description']) ?></p>
                                </div>
                            <?php endforeach; ?>
                        </div>
                        <a href="activity.php" class="btn btn-sm btn-block btn-outline-primary mt-3">View All Activity</a>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Footer (matches your existing site) -->
    <footer class="bg-dark text-white-50 pt-5 pb-4">
        <div class="container text-center">
            <p class="mb-0">JV Overseas Education &copy; <?= date('Y') ?>. All Rights Reserved.</p>
        </div>
    </footer>

    <!-- JavaScript Libraries -->
    <script src="https://code.jquery.com/jquery-3.4.1.min.js"></script>
    <script src="https://stackpath.bootstrapcdn.com/bootstrap/4.4.1/js/bootstrap.bundle.min.js"></script>
    
    <!-- Dashboard-specific JS -->
    <script src="../../js/dashboard.js"></script>
</body>
</html>