<?php
require_once __DIR__ . '/../../includes/dashboard-config.php';

// For role-specific pages, add:
checkRoleAccess(ROLE_STUDENT); // or ROLE_COUNSELOR or ROLE_ADMIN
require_once '../../includes/config.php';
require_once '../../includes/auth.php';
require_once '../../includes/functions.php';

if (!isLoggedIn() || !hasRole('admin')) {
    header('Location: ../login.php');
    exit();
}

// Handle form submission
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (isset($_POST['update_settings'])) {
        try {
            $pdo->beginTransaction();
            
            foreach ($_POST['settings'] as $key => $value) {
                $stmt = $pdo->prepare("UPDATE settings SET setting_value = ? WHERE setting_key = ?");
                $stmt->execute([$value, $key]);
            }
            
            $pdo->commit();
            $_SESSION['success_message'] = "Settings updated successfully!";
        } catch (PDOException $e) {
            $pdo->rollBack();
            $_SESSION['error_message'] = "Error updating settings: " . $e->getMessage();
        }
    }
}

// Get all settings
$settings = $pdo->query("SELECT * FROM settings ORDER BY setting_group, setting_key")->fetchAll(PDO::FETCH_ASSOC);

// Group settings by their group
$grouped_settings = [];
foreach ($settings as $setting) {
    $grouped_settings[$setting['setting_group']][] = $setting;
}

include '../../includes/header.php';
?>

<div class="container py-5">
    <h2 class="mb-4">System Settings</h2>
    
    <?php displayMessages(); ?>
    
    <div class="card">
        <div class="card-header">
            <ul class="nav nav-tabs card-header-tabs" id="settingsTabs" role="tablist">
                <?php foreach ($grouped_settings as $group => $group_settings): ?>
                    <li class="nav-item">
                        <a class="nav-link <?= $group === 'general' ? 'active' : '' ?>" 
                           id="<?= $group ?>-tab" data-toggle="tab" href="#<?= $group ?>" role="tab">
                           <?= ucfirst($group) ?>
                        </a>
                    </li>
                <?php endforeach; ?>
            </ul>
        </div>
        <div class="card-body">
            <form method="post">
                <div class="tab-content" id="settingsTabsContent">
                    <?php foreach ($grouped_settings as $group => $group_settings): ?>
                        <div class="tab-pane fade <?= $group === 'general' ? 'show active' : '' ?>" 
                             id="<?= $group ?>" role="tabpanel">
                            <h5 class="mb-4"><?= ucfirst($group) ?> Settings</h5>
                            
                            <div class="row">
                                <?php foreach ($group_settings as $setting): ?>
                                    <div class="col-md-6 mb-3">
                                        <div class="form-group">
                                            <label for="setting_<?= $setting['setting_key'] ?>">
                                                <?= ucwords(str_replace('_', ' ', $setting['setting_key'])) ?>
                                            </label>
                                            
                                            <?php if ($setting['setting_key'] === 'maintenance_mode'): ?>
                                                <div class="custom-control custom-switch">
                                                    <input type="checkbox" class="custom-control-input" 
                                                           id="setting_<?= $setting['setting_key'] ?>" 
                                                           name="settings[<?= $setting['setting_key'] ?>]" 
                                                           value="1" <?= $setting['setting_value'] ? 'checked' : '' ?>>
                                                    <label class="custom-control-label" for="setting_<?= $setting['setting_key'] ?>">
                                                        <?= $setting['setting_value'] ? 'Enabled' : 'Disabled' ?>
                                                    </label>
                                                </div>
                                            <?php elseif (strpos($setting['setting_key'], 'email') !== false): ?>
                                                <input type="email" class="form-control" 
                                                       id="setting_<?= $setting['setting_key'] ?>" 
                                                       name="settings[<?= $setting['setting_key'] ?>]" 
                                                       value="<?= htmlspecialchars($setting['setting_value']) ?>">
                                            <?php elseif (strpos($setting['setting_key'], 'url') !== false): ?>
                                                <input type="url" class="form-control" 
                                                       id="setting_<?= $setting['setting_key'] ?>" 
                                                       name="settings[<?= $setting['setting_key'] ?>]" 
                                                       value="<?= htmlspecialchars($setting['setting_value']) ?>">
                                            <?php else: ?>
                                                <input type="text" class="form-control" 
                                                       id="setting_<?= $setting['setting_key'] ?>" 
                                                       name="settings[<?= $setting['setting_key'] ?>]" 
                                                       value="<?= htmlspecialchars($setting['setting_value']) ?>">
                                            <?php endif; ?>
                                            
                                            <?php if (!empty($setting['description'])): ?>
                                                <small class="form-text text-muted">
                                                    <?= htmlspecialchars($setting['description']) ?>
                                                </small>
                                            <?php endif; ?>
                                        </div>
                                    </div>
                                <?php endforeach; ?>
                            </div>
                        </div>
                    <?php endforeach; ?>
                </div>
                
                <div class="mt-4">
                    <button type="submit" name="update_settings" class="btn btn-primary">
                        Save All Changes
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>

<script>
// Update switch label text
document.querySelectorAll('.custom-control-input').forEach(switchEl => {
    switchEl.addEventListener('change', function() {
        const label = this.nextElementSibling;
        label.textContent = this.checked ? 'Enabled' : 'Disabled';
    });
});
</script>

<?php include '../../includes/footer.php'; ?>