<?php
require_once __DIR__ . '/../../includes/dashboard-config.php';

// For role-specific pages, add:
checkRoleAccess(ROLE_STUDENT); // or ROLE_COUNSELOR or ROLE_ADMIN
require_once '../../includes/config.php';
require_once '../../includes/auth.php';
require_once '../../includes/functions.php';

if (!isLoggedIn() || !hasRole('counselor')) {
    header('Location: ../login.php');
    exit();
}

$counselor_id = $_SESSION['user_id'];

// Get applications for assigned students
$applications = $pdo->prepare("
    SELECT a.*, s.first_name, s.last_name, u.name as university_name, p.name as program_name
    FROM applications a
    JOIN students s ON a.student_id = s.id
    JOIN programs p ON a.program_id = p.id
    JOIN universities u ON p.university_id = u.id
    WHERE s.assigned_counselor_id = ?
    ORDER BY a.submission_date DESC
");
$applications->execute([$counselor_id]);

// Get status counts for filter
$status_counts = $pdo->prepare("
    SELECT a.application_status, COUNT(*) as count
    FROM applications a
    JOIN students s ON a.student_id = s.id
    WHERE s.assigned_counselor_id = ?
    GROUP BY a.application_status
");
$status_counts->execute([$counselor_id]);

include '../../includes/header.php';
?>

<div class="container py-5">
    <h2 class="mb-4">Student Applications</h2>
    
    <div class="card mb-4">
        <div class="card-header">
            <div class="d-flex justify-content-between align-items-center">
                <h5 class="mb-0">Application Tracker</h5>
                <div class="dropdown">
                    <button class="btn btn-outline-secondary dropdown-toggle" type="button" id="filterDropdown" data-toggle="dropdown">
                        Filter by Status
                    </button>
                    <div class="dropdown-menu dropdown-menu-right">
                        <a class="dropdown-item" href="?status=all">All Applications</a>
                        <?php while ($status = $status_counts->fetch()): ?>
                            <a class="dropdown-item" href="?status=<?= $status['application_status'] ?>">
                                <?= ucwords(str_replace('_', ' ', $status['application_status'])) ?>
                                <span class="badge badge-primary float-right"><?= $status['count'] ?></span>
                            </a>
                        <?php endwhile; ?>
                    </div>
                </div>
            </div>
        </div>
        <div class="card-body">
            <?php if ($applications->rowCount() > 0): ?>
                <div class="table-responsive">
                    <table class="table table-hover">
                        <thead>
                            <tr>
                                <th>Student</th>
                                <th>University</th>
                                <th>Program</th>
                                <th>Status</th>
                                <th>Submitted</th>
                                <th>Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php while ($app = $applications->fetch()): ?>
                                <tr>
                                    <td><?= htmlspecialchars($app['first_name'].' '.$app['last_name']) ?></td>
                                    <td><?= htmlspecialchars($app['university_name']) ?></td>
                                    <td><?= htmlspecialchars($app['program_name']) ?></td>
                                    <td>
                                        <span class="badge badge-<?= 
                                            $app['application_status'] == 'accepted' ? 'success' : 
                                            ($app['application_status'] == 'rejected' ? 'danger' : 'warning') ?>">
                                            <?= ucwords(str_replace('_', ' ', $app['application_status'])) ?>
                                        </span>
                                    </td>
                                    <td><?= $app['submission_date'] ? date('M j, Y', strtotime($app['submission_date'])) : 'Not submitted' ?></td>
                                    <td>
                                        <a href="application-details.php?id=<?= $app['id'] ?>" class="btn btn-sm btn-outline-primary">View</a>
                                        <a href="../messages.php?to=<?= $app['student_id'] ?>" class="btn btn-sm btn-outline-info">Message</a>
                                    </td>
                                </tr>
                            <?php endwhile; ?>
                        </tbody>
                    </table>
                </div>
            <?php else: ?>
                <div class="alert alert-info">
                    No applications found for your assigned students.
                </div>
            <?php endif; ?>
        </div>
    </div>
</div>

<?php include '../../includes/footer.php'; ?>