<?php
require_once __DIR__ . '/../../includes/dashboard-config.php';

// For role-specific pages, add:
checkRoleAccess(ROLE_STUDENT); // or ROLE_COUNSELOR or ROLE_ADMIN
require_once '../../includes/config.php';
require_once '../../includes/auth.php';
require_once '../../includes/functions.php';

if (!isLoggedIn() || !hasRole('counselor')) {
    header('Location: ../login.php');
    exit();
}

$counselor_id = $_SESSION['user_id'];

// Get counselor stats
$assigned_students = $pdo->query("SELECT COUNT(*) FROM students WHERE assigned_counselor_id = $counselor_id")->fetchColumn();
$pending_applications = $pdo->query("SELECT COUNT(*) FROM applications a JOIN students s ON a.student_id = s.id WHERE s.assigned_counselor_id = $counselor_id AND a.application_status IN ('submitted', 'under_review')")->fetchColumn();
$upcoming_appointments = $pdo->query("SELECT COUNT(*) FROM appointments WHERE counselor_id = $counselor_id AND scheduled_time > NOW() AND status = 'scheduled'")->fetchColumn();
$unread_messages = $pdo->query("SELECT COUNT(*) FROM messages WHERE receiver_id = $counselor_id AND is_read = 0")->fetchColumn();

// Get recent activities
$activities = $pdo->query("
    SELECT a.*, s.first_name, s.last_name 
    FROM activities a
    JOIN students s ON a.related_id = s.id
    WHERE a.related_type = 'student' 
    AND s.assigned_counselor_id = $counselor_id
    ORDER BY a.created_at DESC 
    LIMIT 5
")->fetchAll(PDO::FETCH_ASSOC);

include '../../includes/header.php';
?>

<div class="container py-5">
    <h2 class="mb-4">Counselor Dashboard</h2>
    
    <!-- Stats Cards -->
    <div class="row mb-4">
        <div class="col-md-3 mb-3">
            <div class="card bg-primary text-white h-100">
                <div class="card-body">
                    <h6 class="card-title">Assigned Students</h6>
                    <h2 class="mb-0"><?= $assigned_students ?></h2>
                </div>
            </div>
        </div>
        <div class="col-md-3 mb-3">
            <div class="card bg-warning text-white h-100">
                <div class="card-body">
                    <h6 class="card-title">Pending Applications</h6>
                    <h2 class="mb-0"><?= $pending_applications ?></h2>
                </div>
            </div>
        </div>
        <div class="col-md-3 mb-3">
            <div class="card bg-info text-white h-100">
                <div class="card-body">
                    <h6 class="card-title">Upcoming Appointments</h6>
                    <h2 class="mb-0"><?= $upcoming_appointments ?></h2>
                </div>
            </div>
        </div>
        <div class="col-md-3 mb-3">
            <div class="card bg-danger text-white h-100">
                <div class="card-body">
                    <h6 class="card-title">Unread Messages</h6>
                    <h2 class="mb-0"><?= $unread_messages ?></h2>
                </div>
            </div>
        </div>
    </div>
    
    <div class="row">
        <div class="col-lg-8">
            <!-- Recent Activities -->
            <div class="card mb-4">
                <div class="card-header">
                    <h5 class="mb-0">Recent Student Activities</h5>
                </div>
                <div class="card-body">
                    <?php if (count($activities) > 0): ?>
                        <div class="list-group">
                            <?php foreach ($activities as $activity): ?>
                                <div class="list-group-item">
                                    <div class="d-flex justify-content-between">
                                        <div>
                                            <h6 class="mb-1"><?= htmlspecialchars($activity['first_name'].' '.$activity['last_name']) ?></h6>
                                            <p class="mb-1"><?= htmlspecialchars($activity['description']) ?></p>
                                        </div>
                                        <small class="text-muted"><?= formatDate($activity['created_at'], 'M j, g:i a') ?></small>
                                    </div>
                                </div>
                            <?php endforeach; ?>
                        </div>
                    <?php else: ?>
                        <p class="text-muted">No recent activities found.</p>
                    <?php endif; ?>
                </div>
            </div>
        </div>
        
        <div class="col-lg-4">
            <!-- Quick Actions -->
            <div class="card">
                <div class="card-header">
                    <h5 class="mb-0">Quick Actions</h5>
                </div>
                <div class="card-body">
                    <div class="list-group">
                        <a href="students.php" class="list-group-item list-group-item-action">
                            <i class="fas fa-users mr-2"></i>View My Students
                        </a>
                        <a href="applications.php" class="list-group-item list-group-item-action">
                            <i class="fas fa-file-alt mr-2"></i>Manage Applications
                        </a>
                        <a href="appointments.php" class="list-group-item list-group-item-action">
                            <i class="fas fa-calendar-check mr-2"></i>Schedule Appointment
                        </a>
                        <a href="messages.php" class="list-group-item list-group-item-action">
                            <i class="fas fa-envelope mr-2"></i>Check Messages
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<?php include '../../includes/footer.php'; ?>