<?php
require_once __DIR__ . '/../../includes/dashboard-config.php';

// For role-specific pages, add:
checkRoleAccess(ROLE_STUDENT); // or ROLE_COUNSELOR or ROLE_ADMIN
require_once '../../includes/config.php';
require_once '../../includes/auth.php';
require_once '../../includes/functions.php';

if (!isLoggedIn() || !hasRole('counselor')) {
    header('Location: ../login.php');
    exit();
}

$counselor_id = $_SESSION['user_id'];

// Get assigned students
$students = $pdo->prepare("
    SELECT s.*, COUNT(a.id) as application_count 
    FROM students s
    LEFT JOIN applications a ON s.id = a.student_id
    WHERE s.assigned_counselor_id = ?
    GROUP BY s.id
    ORDER BY s.first_name
");
$students->execute([$counselor_id]);

include '../../includes/header.php';
?>

<div class="container py-5">
    <h2 class="mb-4">My Assigned Students</h2>
    
    <div class="card">
        <div class="card-body">
            <?php if ($students->rowCount() > 0): ?>
                <div class="table-responsive">
                    <table class="table table-hover">
                        <thead>
                            <tr>
                                <th>Student</th>
                                <th>Contact</th>
                                <th>Applications</th>
                                <th>Status</th>
                                <th>Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php while ($student = $students->fetch()): ?>
                                <tr>
                                    <td>
                                        <strong><?= htmlspecialchars($student['first_name'].' '.$student['last_name']) ?></strong><br>
                                        <small class="text-muted"><?= htmlspecialchars($student['email']) ?></small>
                                    </td>
                                    <td>
                                        <?= htmlspecialchars($student['phone']) ?><br>
                                        <?= htmlspecialchars($student['country']) ?>
                                    </td>
                                    <td><?= $student['application_count'] ?></td>
                                    <td>
                                        <span class="badge badge-<?= 
                                            $student['status'] == 'active' ? 'success' : 
                                            ($student['status'] == 'prospective' ? 'warning' : 'secondary') ?>">
                                            <?= ucfirst($student['status']) ?>
                                        </span>
                                    </td>
                                    <td>
                                        <a href="student-details.php?id=<?= $student['id'] ?>" 
                                           class="btn btn-sm btn-outline-primary">
                                            View
                                        </a>
                                        <a href="../messages.php?to=<?= $student['id'] ?>" 
                                           class="btn btn-sm btn-outline-info">
                                            Message
                                        </a>
                                    </td>
                                </tr>
                            <?php endwhile; ?>
                        </tbody>
                    </table>
                </div>
            <?php else: ?>
                <div class="alert alert-info">
                    You don't have any assigned students yet.
                </div>
            <?php endif; ?>
        </div>
    </div>
</div>

<?php include '../../includes/footer.php'; ?>