<?php
require_once __DIR__ . '/../../includes/dashboard-config.php';

// For role-specific pages, add:
checkRoleAccess(ROLE_STUDENT); // or ROLE_COUNSELOR or ROLE_ADMIN
require_once '../../includes/config.php';
require_once '../../includes/auth.php';
require_once '../../includes/functions.php';

if (!isLoggedIn() || !hasRole('student')) {
    header('Location: ../login.php');
    exit();
}

$student_id = $_SESSION['user_id'];

// Handle feedback submission
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['submit_feedback'])) {
    $rating = $_POST['rating'];
    $comments = $_POST['comments'];
    $counselor_id = $_POST['counselor_id'];
    
    try {
        $stmt = $pdo->prepare("INSERT INTO feedback 
                             (student_id, counselor_id, rating, comments) 
                             VALUES (?, ?, ?, ?)");
        $stmt->execute([$student_id, $counselor_id, $rating, $comments]);
        
        $_SESSION['success_message'] = "Thank you for your feedback!";
        header("Location: feedback.php");
        exit();
    } catch (PDOException $e) {
        $_SESSION['error_message'] = "Error submitting feedback: " . $e->getMessage();
    }
}

// Get student's assigned counselor
$counselor = $pdo->prepare("
    SELECT c.id, c.first_name, c.last_name 
    FROM counselors c
    JOIN students s ON c.id = s.assigned_counselor_id
    WHERE s.id = ?
");
$counselor->execute([$student_id]);
$counselor = $counselor->fetch();

// Get past feedback
$feedback_history = $pdo->prepare("
    SELECT f.*, c.first_name, c.last_name 
    FROM feedback f
    JOIN counselors c ON f.counselor_id = c.id
    WHERE f.student_id = ?
    ORDER BY f.created_at DESC
");
$feedback_history->execute([$student_id]);

include '../../includes/header.php';
?>

<div class="container py-5">
    <h2 class="mb-4">Service Feedback</h2>
    
    <?php displayMessages(); ?>
    
    <div class="row">
        <div class="col-lg-6">
            <div class="card mb-4">
                <div class="card-header">
                    <h5 class="mb-0">Submit Feedback</h5>
                </div>
                <div class="card-body">
                    <?php if ($counselor): ?>
                        <form method="post">
                            <input type="hidden" name="counselor_id" value="<?= $counselor['id'] ?>">
                            
                            <div class="form-group">
                                <label>Counselor</label>
                                <p class="form-control-static">
                                    <?= htmlspecialchars($counselor['first_name'].' '.$counselor['last_name']) ?>
                                </p>
                            </div>
                            
                            <div class="form-group">
                                <label for="rating">Rating</label>
                                <div class="star-rating">
                                    <?php for ($i = 5; $i >= 1; $i--): ?>
                                        <input type="radio" id="star-<?= $i ?>" name="rating" value="<?= $i ?>" required>
                                        <label for="star-<?= $i ?>"></label>
                                    <?php endfor; ?>
                                </div>
                            </div>
                            
                            <div class="form-group">
                                <label for="comments">Comments</label>
                                <textarea class="form-control" id="comments" name="comments" rows="4" 
                                          placeholder="What did you like about our service? How can we improve?"></textarea>
                            </div>
                            
                            <button type="submit" name="submit_feedback" class="btn btn-primary">
                                Submit Feedback
                            </button>
                        </form>
                    <?php else: ?>
                        <div class="alert alert-info">
                            You don't have an assigned counselor to provide feedback for.
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
        
        <div class="col-lg-6">
            <div class="card">
                <div class="card-header">
                    <h5 class="mb-0">Your Feedback History</h5>
                </div>
                <div class="card-body">
                    <?php if ($feedback_history->rowCount() > 0): ?>
                        <div class="list-group">
                            <?php while ($feedback = $feedback_history->fetch()): ?>
                                <div class="list-group-item">
                                    <div class="d-flex justify-content-between">
                                        <div>
                                            <h6 class="mb-1"><?= htmlspecialchars($feedback['first_name'].' '.$feedback['last_name']) ?></h6>
                                            <div class="star-rating-view mb-2">
                                                <?php for ($i = 1; $i <= 5; $i++): ?>
                                                    <i class="fas fa-star <?= $i <= $feedback['rating'] ? 'text-warning' : 'text-secondary' ?>"></i>
                                                <?php endfor; ?>
                                            </div>
                                            <?php if (!empty($feedback['comments'])): ?>
                                                <p class="mb-1"><?= htmlspecialchars($feedback['comments']) ?></p>
                                            <?php endif; ?>
                                        </div>
                                        <small class="text-muted">
                                            <?= date('M j, Y', strtotime($feedback['created_at'])) ?>
                                        </small>
                                    </div>
                                </div>
                            <?php endwhile; ?>
                        </div>
                    <?php else: ?>
                        <div class="alert alert-info">
                            You haven't submitted any feedback yet.
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
</div>

<style>
.star-rating {
    direction: rtl;
    display: inline-block;
}

.star-rating input {
    display: none;
}

.star-rating label {
    color: #ddd;
    font-size: 24px;
    padding: 0 5px;
    cursor: pointer;
}

.star-rating input:checked ~ label,
.star-rating label:hover,
.star-rating label:hover ~ label {
    color: #ffc107;
}

.star-rating-view {
    font-size: 18px;
}
</style>

<script>
// Star rating interaction
document.querySelectorAll('.star-rating input').forEach(radio => {
    radio.addEventListener('change', function() {
        const rating = this.value;
        // You can add any additional logic here if needed
    });
});
</script>

<?php include '../../includes/footer.php'; ?>