<?php
require_once __DIR__ . '/../../includes/dashboard-config.php';

// For role-specific pages, add:
checkRoleAccess(ROLE_STUDENT); // or ROLE_COUNSELOR or ROLE_ADMIN
require_once '../../includes/config.php';
require_once '../../includes/auth.php';
require_once '../../includes/functions.php';

if (!isLoggedIn() || !hasRole('student')) {
    header('Location: ../login.php');
    exit();
}

$student_id = $_SESSION['user_id'];

// Get visa applications
$visa_applications = $pdo->prepare("
    SELECT v.*, c.name AS country_name 
    FROM visa_applications v
    JOIN countries c ON v.country_id = c.id
    WHERE v.student_id = ?
    ORDER BY v.application_date DESC
");
$visa_applications->execute([$student_id]);
$visa_applications = $visa_applications->fetchAll(PDO::FETCH_ASSOC);

// Get visa checklist
$checklist = $pdo->query("
    SELECT * FROM visa_checklist
    ORDER BY document_name
")->fetchAll(PDO::FETCH_ASSOC);

include '../../includes/header.php';
?>

<div class="container py-5">
    <h2 class="mb-4">Visa Application Center</h2>
    
    <div class="row">
        <div class="col-lg-8">
            <div class="card mb-4">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h5 class="mb-0">My Visa Applications</h5>
                    <button class="btn btn-primary" data-toggle="modal" data-target="#newVisaModal">
                        <i class="fas fa-plus"></i> New Application
                    </button>
                </div>
                <div class="card-body">
                    <?php if (count($visa_applications) > 0): ?>
                        <div class="table-responsive">
                            <table class="table table-hover">
                                <thead>
                                    <tr>
                                        <th>Country</th>
                                        <th>Status</th>
                                        <th>Applied</th>
                                        <th>Decision</th>
                                        <th>Actions</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php foreach ($visa_applications as $visa): ?>
                                        <tr>
                                            <td><?= htmlspecialchars($visa['country_name']) ?></td>
                                            <td>
                                                <span class="badge badge-<?= 
                                                    $visa['status'] == 'approved' ? 'success' : 
                                                    ($visa['status'] == 'rejected' ? 'danger' : 'warning') ?>">
                                                    <?= ucwords(str_replace('_', ' ', $visa['status'])) ?>
                                                </span>
                                            </td>
                                            <td><?= formatDate($visa['application_date']) ?></td>
                                            <td><?= formatDate($visa['decision_date']) ?></td>
                                            <td>
                                                <a href="visa-details.php?id=<?= $visa['id'] ?>" 
                                                   class="btn btn-sm btn-outline-primary">
                                                    Details
                                                </a>
                                            </td>
                                        </tr>
                                    <?php endforeach; ?>
                                </tbody>
                            </table>
                        </div>
                    <?php else: ?>
                        <div class="alert alert-info">
                            You haven't started any visa applications yet.
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
        
        <div class="col-lg-4">
            <div class="card">
                <div class="card-header">
                    <h5 class="mb-0">Visa Document Checklist</h5>
                </div>
                <div class="card-body">
                    <ul class="list-group">
                        <?php foreach ($checklist as $item): ?>
                            <li class="list-group-item d-flex justify-content-between align-items-center">
                                <?= htmlspecialchars($item['document_name']) ?>
                                <?php if ($item['is_required']): ?>
                                    <span class="badge badge-primary">Required</span>
                                <?php endif; ?>
                            </li>
                        <?php endforeach; ?>
                    </ul>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- New Visa Application Modal -->
<div class="modal fade" id="newVisaModal" tabindex="-1" role="dialog">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <form method="post" action="process-visa.php">
                <div class="modal-header">
                    <h5 class="modal-title">New Visa Application</h5>
                    <button type="button" class="close" data-dismiss="modal">
                        <span>&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <div class="form-group">
                        <label for="country_id">Destination Country</label>
                        <select class="form-control" id="country_id" name="country_id" required>
                            <option value="">Select country</option>
                            <?php 
                            $countries = $pdo->query("SELECT * FROM countries ORDER BY name")->fetchAll();
                            foreach ($countries as $country): ?>
                                <option value="<?= $country['id'] ?>"><?= htmlspecialchars($country['name']) ?></option>
                            <?php endforeach; ?>
                        </select>
                    </div>
                    <div class="form-group">
                        <label for="visa_type">Visa Type</label>
                        <input type="text" class="form-control" id="visa_type" name="visa_type" 
                               placeholder="e.g., Student Visa, Tier 4 Visa" required>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancel</button>
                    <button type="submit" class="btn btn-primary">Start Application</button>
                </div>
            </form>
        </div>
    </div>
</div>

<?php include '../../includes/footer.php'; ?>