<?php
// Define absolute path to project root
define('ROOT_PATH', dirname(__DIR__));

// Database configuration
define('DB_HOST', 'localhost');
define('DB_NAME', 'jv_overseas');
define('DB_USER', 'root');
define('DB_PASS', '');

// Base URL configuration
define('BASE_URL', 'http://localhost/jv-overseas/');

// Start session
session_start();

// Error reporting (for development)
error_reporting(E_ALL);
ini_set('display_errors', 1);

try {
    // Create PDO connection
    $pdo = new PDO("mysql:host=".DB_HOST.";dbname=".DB_NAME, DB_USER, DB_PASS);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
    $pdo->setAttribute(PDO::ATTR_DEFAULT_FETCH_MODE, PDO::FETCH_ASSOC);
} catch (PDOException $e) {
    die("Database connection failed: " . $e->getMessage());
}

// Include other common files
require_once ROOT_PATH . '/includes/functions.php';
require_once ROOT_PATH . '/includes/auth.php';
?>