<?php
// Display flash messages
function displayMessages() {
    if (isset($_SESSION['success_message'])) {
        echo '<div class="alert alert-success alert-dismissible fade show">
                '.$_SESSION['success_message'].'
                <button type="button" class="close" data-dismiss="alert">
                    <span>&times;</span>
                </button>
              </div>';
        unset($_SESSION['success_message']);
    }
    
    if (isset($_SESSION['error_message'])) {
        echo '<div class="alert alert-danger alert-dismissible fade show">
                '.$_SESSION['error_message'].'
                <button type="button" class="close" data-dismiss="alert">
                    <span>&times;</span>
                </button>
              </div>';
        unset($_SESSION['error_message']);
    }
}

// Handle file uploads
function handleFileUpload($file, $subfolder = '') {
    $result = ['success' => false];
    
    // Check for errors
    if ($file['error'] !== UPLOAD_ERR_OK) {
        $result['error'] = "File upload error: " . $file['error'];
        return $result;
    }
    
    // Check file size
    if ($file['size'] > MAX_FILE_SIZE) {
        $result['error'] = "File is too large. Maximum size is " . (MAX_FILE_SIZE / 1024 / 1024) . "MB.";
        return $result;
    }
    
    // Get file extension
    $fileExt = strtolower(pathinfo($file['name'], PATHINFO_EXTENSION));
    
    // Check allowed file types
    if (!in_array($fileExt, ALLOWED_FILE_TYPES)) {
        $result['error'] = "Invalid file type. Allowed types: " . implode(', ', ALLOWED_FILE_TYPES);
        return $result;
    }
    
    // Create upload directory if not exists
    $uploadDir = UPLOAD_PATH . $subfolder;
    if (!file_exists($uploadDir)) {
        mkdir($uploadDir, 0777, true);
    }
    
    // Generate unique filename
    $fileName = uniqid() . '.' . $fileExt;
    $filePath = $subfolder ? $subfolder . '/' . $fileName : $fileName;
    $destination = $uploadDir . '/' . $fileName;
    
    // Move uploaded file
    if (move_uploaded_file($file['tmp_name'], $destination)) {
        $result['success'] = true;
        $result['path'] = 'uploads/' . $filePath;
    } else {
        $result['error'] = "Failed to move uploaded file.";
    }
    
    return $result;
}

// Generate a random password
function generateRandomPassword($length = 12) {
    $chars = 'abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789!@#$%^&*()';
    $password = '';
    for ($i = 0; $i < $length; $i++) {
        $password .= $chars[random_int(0, strlen($chars) - 1)];
    }
    return $password;
}

// Format date for display
function formatDate($date, $format = 'M j, Y') {
    return $date ? date($format, strtotime($date)) : 'N/A';
}

// Get user's full name by ID
function getUserFullName($id) {
    global $pdo;
    
    $stmt = $pdo->prepare("SELECT first_name, last_name FROM users WHERE id = ?");
    $stmt->execute([$id]);
    $user = $stmt->fetch();
    
    return $user ? $user['first_name'] . ' ' . $user['last_name'] : 'Unknown User';
}
?>