<?php
// Start session for navbar
session_start();
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <title>Our Services - JV Overseas Education</title>
    <meta content="width=device-width, initial-scale=1.0" name="viewport">
    <link rel="preconnect" href="https://fonts.gstatic.com">
    <link href="https://fonts.googleapis.com/css2?family=Jost:wght@500;600;700&family=Open+Sans:wght@400;600&display=swap" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.10.0/css/all.min.css" rel="stylesheet">
    <link href="lib/owlcarousel/assets/owl.carousel.min.css" rel="stylesheet">
    <link href="css/style.css" rel="stylesheet">
    <style>
        .service-icon {
            width: 80px;
            height: 80px;
            display: flex;
            align-items: center;
            justify-content: center;
            border-radius: 50%;
            margin-bottom: 20px;
        }
        .service-card {
            transition: all 0.3s;
            border: 1px solid #eee;
            border-radius: 10px;
            padding: 30px;
            margin-bottom: 30px;
            background: #fff;
        }
        .service-card:hover {
            transform: translateY(-10px);
            box-shadow: 0 10px 20px rgba(0,0,0,0.1);
        }
        .process-step {
            position: relative;
            padding: 20px 0 20px 60px;
            border-left: 3px solid #3fb7fe;
        }
        .process-step:before {
            content: "";
            position: absolute;
            left: -12px;
            top: 25px;
            width: 24px;
            height: 24px;
            border-radius: 50%;
            background: #3fb7fe;
            z-index: 1;
        }
        .process-step h5 {
            margin-bottom: 10px;
        }
        .rating {
            color: #ffc107;
            margin-bottom: 10px;
        }
        
        /* Fix for white text on white background */
        .bg-registration {
            background: linear-gradient(rgba(63, 183, 254, 0.9), rgba(63, 183, 254, 0.9)), url('img/registration-bg.jpg') center center no-repeat;
            background-size: cover;
        }
        
        .bg-registration * {
            color: #333 !important;
        }
        
        .bg-registration .text-white {
            color: #333 !important;
        }
    </style>
</head>
<body>

<?php include 'navbar.php'; ?>

<!-- Header Start -->
<div class="jumbotron jumbotron-fluid position-relative overlay-bottom" style="margin-bottom: 90px;">
    <div class="container text-center my-5 py-5">
        <h1 class="text-white mt-4 mb-4">Comprehensive Education Services</h1>
        <h1 class="text-white display-1 mb-5">Your Journey, Our Expertise</h1>
        <p class="text-white mb-5">We provide end-to-end support for your study abroad journey, from initial counseling to post-arrival assistance.</p>
        <a href="apply.php" class="btn btn-outline-primary mr-3 py-3 px-5">Free Consultation</a>
        <a href="contact.php" class="btn btn-primary py-3 px-5">Contact Us</a>
    </div>
</div>
<!-- Header End -->

<!-- Services Start -->
<div class="container-fluid py-5">
    <div class="container py-5">
        <div class="text-center mb-5">
            <h5 class="text-primary text-uppercase mb-3" style="letter-spacing: 5px;">Our Services</h5>
            <h1>Comprehensive Study Abroad Support</h1>
        </div>
        <div class="row">
            <div class="col-lg-4 col-md-6 mb-5">
                <div class="service-card text-center">
                    <div class="service-icon bg-primary text-white mx-auto mb-4">
                        <i class="fa fa-2x fa-graduation-cap"></i>
                    </div>
                    <h5 class="mb-3">Education Counseling</h5>
                    <p class="text-muted">Personalized guidance to help you choose the right destination, university, and program based on your academic background, career goals, and budget.</p>
                    <ul class="list-unstyled text-left mt-3">
                        <li class="mb-2"><i class="fa fa-check text-primary mr-2"></i> Career assessment and planning</li>
                        <li class="mb-2"><i class="fa fa-check text-primary mr-2"></i> University and program selection</li>
                        <li class="mb-2"><i class="fa fa-check text-primary mr-2"></i> Scholarship and funding guidance</li>
                        <li class="mb-2"><i class="fa fa-check text-primary mr-2"></i> Academic profile evaluation</li>
                    </ul>
                </div>
            </div>
            <div class="col-lg-4 col-md-6 mb-5">
                <div class="service-card text-center">
                    <div class="service-icon bg-secondary text-white mx-auto mb-4">
                        <i class="fa fa-2x fa-university"></i>
                    </div>
                    <h5 class="mb-3">University Admission</h5>
                    <p class="text-muted">End-to-end application support to ensure your application stands out and meets all university requirements.</p>
                    <ul class="list-unstyled text-left mt-3">
                        <li class="mb-2"><i class="fa fa-check text-primary mr-2"></i> Application form completion</li>
                        <li class="mb-2"><i class="fa fa-check text-primary mr-2"></i> Document preparation and verification</li>
                        <li class="mb-2"><i class="fa fa-check text-primary mr-2"></i> Application tracking and follow-up</li>
                        <li class="mb-2"><i class="fa fa-check text-primary mr-2"></i> Offer letter processing</li>
                    </ul>
                </div>
            </div>
            <div class="col-lg-4 col-md-6 mb-5">
                <div class="service-card text-center">
                    <div class="service-icon bg-primary text-white mx-auto mb-4">
                        <i class="fa fa-2x fa-passport"></i>
                    </div>
                    <h5 class="mb-3">Visa Assistance</h5>
                    <p class="text-muted">Expert visa guidance with a 100% success rate, including documentation, interview preparation, and financial proof.</p>
                    <ul class="list-unstyled text-left mt-3">
                        <li class="mb-2"><i class="fa fa-check text-primary mr-2"></i> Visa eligibility assessment</li>
                        <li class="mb-2"><i class="fa fa-check text-primary mr-2"></i> Document checklist and verification</li>
                        <li class="mb-2"><i class="fa fa-check text-primary mr-2"></i> Interview preparation and mock sessions</li>
                        <li class="mb-2"><i class="fa fa-check text-primary mr-2"></i> Application submission support</li>
                    </ul>
                </div>
            </div>
            <div class="col-lg-4 col-md-6 mb-5">
                <div class="service-card text-center">
                    <div class="service-icon bg-secondary text-white mx-auto mb-4">
                        <i class="fa fa-2x fa-plane"></i>
                    </div>
                    <h5 class="mb-3">Travel Arrangements</h5>
                    <p class="text-muted">Seamless travel planning including flight bookings, airport pickup, and pre-departure orientation.</p>
                    <ul class="list-unstyled text-left mt-3">
                        <li class="mb-2"><i class="fa fa-check text-primary mr-2"></i> Flight booking assistance</li>
                        <li class="mb-2"><i class="fa fa-check text-primary mr-2"></i> Airport pickup arrangements</li>
                        <li class="mb-2"><i class="fa fa-check text-primary mr-2"></i> Pre-departure orientation</li>
                        <li class="mb-2"><i class="fa fa-check text-primary mr-2"></i> Travel insurance guidance</li>
                    </ul>
                </div>
            </div>
            <div class="col-lg-4 col-md-6 mb-5">
                <div class="service-card text-center">
                    <div class="service-icon bg-primary text-white mx-auto mb-4">
                        <i class="fa fa-2x fa-home"></i>
                    </div>
                    <h5 class="mb-3">Accommodation Support</h5>
                    <p class="text-muted">Finding the perfect place to live, from university dormitories to private apartments and homestays.</p>
                    <ul class="list-unstyled text-left mt-3">
                        <li class="mb-2"><i class="fa fa-check text-primary mr-2"></i> On-campus housing guidance</li>
                        <li class="mb-2"><i class="fa fa-check text-primary mr-2"></i> Private accommodation search</li>
                        <li class="mb-2"><i class="fa fa-check text-primary mr-2"></i> Homestay arrangements</li>
                        <li class="mb-2"><i class="fa fa-check text-primary mr-2"></i> Lease agreement review</li>
                    </ul>
                </div>
            </div>
            <div class="col-lg-4 col-md-6 mb-5">
                <div class="service-card text-center">
                    <div class="service-icon bg-secondary text-white mx-auto mb-4">
                        <i class="fa fa-2x fa-book"></i>
                    </div>
                    <h5 class="mb-3">Test Preparation</h5>
                    <p class="text-muted">Comprehensive preparation for language and academic tests including IELTS, TOEFL, GRE, and GMAT.</p>
                    <ul class="list-unstyled text-left mt-3">
                        <li class="mb-2"><i class="fa fa-check text-primary mr-2"></i> IELTS/TOEFL coaching</li>
                        <li class="mb-2"><i class="fa fa-check text-primary mr-2"></i> GRE/GMAT preparation</li>
                        <li class="mb-2"><i class="fa fa-check text-primary mr-2"></i> Practice tests and evaluation</li>
                        <li class="mb-2"><i class="fa fa-check text-primary mr-2"></i> Test strategy and tips</li>
                    </ul>
                </div>
            </div>
        </div>
    </div>
</div>
<!-- Services End -->

<!-- Process Start -->
<div class="container-fluid bg-image py-5" style="margin: 90px 0;">
    <div class="container py-5">
        <div class="row align-items-center">
            <div class="col-lg-6 mb-5 mb-lg-0">
                <h1 class="text-dark mb-4">Our Application Process</h1>
                <p class="mb-4 text-dark">We follow a systematic approach to ensure your application is successful and stress-free.</p>
                <div class="process-step">
                    <h5 class="text-dark">Initial Consultation</h5>
                    <p class="text-dark">We begin with a comprehensive assessment of your academic background, career goals, and preferences to understand your needs.</p>
                </div>
                <div class="process-step">
                    <h5 class="text-dark">University Selection</h5>
                    <p class="text-dark">Based on your profile, we recommend suitable universities and programs that match your academic and career objectives.</p>
                </div>
                <div class="process-step">
                    <h5 class="text-dark">Application Preparation</h5>
                    <p class="text-dark">We assist with all aspects of your application, including document preparation, statement of purpose, and recommendation letters.</p>
                </div>
                <div class="process-step">
                    <h5 class="text-dark">Visa Processing</h5>
                    <p class="text-dark">Our visa experts guide you through the entire visa application process, ensuring all documentation is complete and accurate.</p>
                </div>
                <div class="process-step">
                    <h5 class="text-dark">Pre-Departure Support</h5>
                    <p class="text-dark">We provide comprehensive pre-departure guidance, including travel arrangements, accommodation, and cultural orientation.</p>
                </div>
            </div>
            <div class="col-lg-6">
                <div class="bg-white text-center rounded p-5">
                    <h3 class="mb-4">Get Started Today</h3>
                    <p class="mb-4">Take the first step towards your global education journey with a free consultation.</p>
                    <form>
                        <div class="form-group">
                            <input type="text" class="form-control border-0 py-4" placeholder="Your Name" required="required" />
                        </div>
                        <div class="form-group">
                            <input type="email" class="form-control border-0 py-4" placeholder="Your Email" required="required" />
                        </div>
                        <div class="form-group">
                            <select class="custom-select border-0 px-4" style="height: 47px;">
                                <option selected>Choose Service</option>
                                <option value="1">Education Counseling</option>
                                <option value="2">University Admission</option>
                                <option value="3">Visa Assistance</option>
                                <option value="4">Travel Arrangements</option>
                                <option value="5">Accommodation Support</option>
                                <option value="6">Test Preparation</option>
                            </select>
                        </div>
                        <div>
                            <button class="btn btn-primary btn-block border-0 py-3" type="submit">Request Free Consultation</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
<!-- Process End -->

<!-- Why Choose Start -->
<div class="container-fluid py-5">
    <div class="container py-5">
        <div class="text-center mb-5">
            <h5 class="text-primary text-uppercase mb-3" style="letter-spacing: 5px;">Why Choose Us</h5>
            <h1>Why Students Trust Our Services</h1>
        </div>
        <div class="row">
            <div class="col-lg-4 col-md-6 mb-5">
                <div class="d-flex align-items-center mb-3">
                    <i class="fa fa-2x fa-check-circle text-primary mr-3"></i>
                    <h5 class="mb-0">100% Visa Success Rate</h5>
                </div>
                <p>Our expert visa counselors have a proven track record of successful visa applications across all major destinations.</p>
            </div>
            <div class="col-lg-4 col-md-6 mb-5">
                <div class="d-flex align-items-center mb-3">
                    <i class="fa fa-2x fa-user-tie text-primary mr-3"></i>
                    <h5 class="mb-0">Dedicated Counselor</h5>
                </div>
                <p>Each student is assigned a dedicated counselor who provides personalized guidance throughout the entire process.</p>
            </div>
            <div class="col-lg-4 col-md-6 mb-5">
                <div class="d-flex align-items-center mb-3">
                    <i class="fa fa-2x fa-clock text-primary mr-3"></i>
                    <h5 class="mb-0">24/7 Support</h5>
                </div>
                <p>We offer round-the-clock support to address your queries and concerns, regardless of time zones.</p>
            </div>
            <div class="col-lg-4 col-md-6 mb-5">
                <div class="d-flex align-items-center mb-3">
                    <i class="fa fa-2x fa-award text-primary mr-3"></i>
                    <h5 class="mb-0">Scholarship Expertise</h5>
                </div>
                <p>Our counselors have extensive experience in securing scholarships and financial aid for students.</p>
            </div>
            <div class="col-lg-4 col-md-6 mb-5">
                <div class="d-flex align-items-center mb-3">
                    <i class="fa fa-2x fa-handshake text-primary mr-3"></i>
                    <h5 class="mb-0">No Processing Fees</h5>
                </div>
                <p>We don't charge any processing fees for our services. You only pay when you receive your offer letter.</p>
            </div>
            <div class="col-lg-4 col-md-6 mb-5">
                <div class="d-flex align-items-center mb-3">
                    <i class="fa fa-2x fa-globe text-primary mr-3"></i>
                    <h5 class="mb-0">Global Network</h5>
                </div>
                <p>We have established partnerships with over 200 universities worldwide, giving you access to exclusive opportunities.</p>
            </div>
        </div>
    </div>
</div>
<!-- Why Choose End -->

<!-- Registration Start -->
<div class="container-fluid bg-registration py-5" style="margin: 90px 0;">
    <div class="container py-5">
        <div class="row align-items-center">
            <div class="col-lg-7 mb-5 mb-lg-0">
                <div class="mb-4">
                    <h6 class="text-primary text-uppercase" style="letter-spacing: 5px;">Get In Touch</h6>
                    <h1 class="text-dark">Get 20% Off For Online Registration</h1>
                </div>
                <p class="text-dark">Register for a free consultation today and receive personalized guidance on your study abroad journey from our expert counselors.</p>
                <ul class="list-unstyled text-dark m-0">
                    <li class="py-2"><i class="fa fa-check text-primary mr-3"></i>Free Initial Consultation</li>
                    <li class="py-2"><i class="fa fa-check text-primary mr-3"></i>Personalized University Selection</li>
                    <li class="py-2"><i class="fa fa-check text-primary mr-3"></i>Application and Visa Support</li>
                </ul>
            </div>
            <div class="col-lg-5">
                <div class="card border-0">
                    <div class="card-header bg-light text-center p-4">
                        <h1 class="m-0">Get Free Consultation</h1>
                    </div>
                    <div class="card-body rounded-bottom bg-primary p-5">
                        <form action="apply.php">
                            <div class="form-group">
                                <input type="text" class="form-control border-0 p-4" placeholder="Your Name" required="required" />
                            </div>
                            <div class="form-group">
                                <input type="email" class="form-control border-0 p-4" placeholder="Your Email" required="required" />
                            </div>
                            <div class="form-group">
                                <select class="custom-select border-0 px-4" style="height: 47px;">
                                    <option selected>Choose Service</option>
                                    <option value="1">Education Counseling</option>
                                    <option value="2">University Admission</option>
                                    <option value="3">Visa Assistance</option>
                                    <option value="4">Travel Arrangements</option>
                                    <option value="5">Accommodation Support</option>
                                    <option value="6">Test Preparation</option>
                                </select>
                            </div>
                            <div>
                                <button class="btn btn-dark btn-block border-0 py-3" type="submit">Get Consultation</button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<!-- Registration End -->

<?php include 'footer.php'; ?>
<script src="https://code.jquery.com/jquery-3.4.1.min.js"></script>
<script src="https://stackpath.bootstrapcdn.com/bootstrap/4.4.1/js/bootstrap.bundle.min.js"></script>
<script src="lib/easing/easing.min.js"></script>
<script src="lib/waypoints/waypoints.min.js"></script>
<script src="lib/counterup/counterup.min.js"></script>
<script src="lib/owlcarousel/owl.carousel.min.js"></script>
<script src="mail/jqBootstrapValidation.min.js"></script>
<script src="mail/contact.js"></script>
<script src="js/main.js"></script>
</body>
</html>