<?php
session_start();
require_once 'config.php';

if (!isset($_SESSION['user_id']) || $_SESSION['user_type'] !== 'student') {
    header('Location: student-login.php');
    exit;
}

$stmt = $pdo->prepare("SELECT a.*, c.first_name as counselor_first, c.last_name as counselor_last
                      FROM appointments a
                      JOIN counselors c ON a.counselor_id = c.id
                      WHERE a.student_id = ? ORDER BY a.scheduled_time DESC");
$stmt->execute([$_SESSION['user_id']]);
$appointments = $stmt->fetchAll();
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <title>Appointments - JV Overseas Education</title>
    <link href="https://fonts.googleapis.com/css2?family=Jost:wght@500;600;700&family=Open+Sans:wght@400;600&display=swap" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.10.0/css/all.min.css" rel="stylesheet">
    <link href="css/style.css" rel="stylesheet">
</head>
<body>

<?php include 'student-navbar.php'; ?>

<div class="container py-5">
    <div class="section-title mb-4">
        <h1 class="display-6">My Appointments</h1>
    </div>
    <div class="table-responsive">
        <table class="table table-bordered">
            <thead>
                <tr>
                    <th>Type</th>
                    <th>Counselor</th>
                    <th>Date & Time</th>
                    <th>Status</th>
                    <th>Actions</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($appointments as $appt): ?>
                <tr>
                    <td><?= ucfirst($appt['appointment_type']) ?></td>
                    <td><?= htmlspecialchars($appt['counselor_first'] . ' ' . $appt['counselor_last']) ?></td>
                    <td><?= date('M j, Y H:i', strtotime($appt['scheduled_time'])) ?></td>
                    <td><span class="badge badge-<?= $appt['status'] === 'scheduled' ? 'primary' : 'secondary' ?>">
                        <?= ucfirst($appt['status']) ?></span></td>
                    <td>
                        <a href="<?= $appt['google_meet_link'] ?>" class="btn btn-sm btn-primary" target="_blank">Join</a>
                    </td>
                </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    </div>
    <a href="book-new-appointment.php" class="btn btn-primary">Book New Appointment</a>
</div>


<script src="https://code.jquery.com/jquery-3.4.1.min.js"></script>
<script src="https://stackpath.bootstrapcdn.com/bootstrap/4.4.1/js/bootstrap.bundle.min.js"></script>
</body>
</html>