<?php
session_start();
require_once 'config.php';

// Authentication check
if (!isset($_SESSION['user_id']) || $_SESSION['user_type'] !== 'student') {
    header('Location: student-login.php');
    exit;
}

// Get student documents
try {
    $stmt = $pdo->prepare("SELECT * FROM student_documents WHERE student_id = ? ORDER BY created_at DESC");
    $stmt->execute([$_SESSION['user_id']]);
    $documents = $stmt->fetchAll();
} catch (PDOException $e) {
    die("Error fetching documents: " . $e->getMessage());
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <title>Documents - JV Overseas Education</title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link href="https://fonts.googleapis.com/css2?family=Jost:wght@500;600;700&family=Open+Sans:wght@400;600&display=swap" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.10.0/css/all.min.css" rel="stylesheet">
    <link href="css/style.css" rel="stylesheet">
    <style>
        .badge-success {
            background-color: #28a745;
        }
        .badge-info {
            background-color: #17a2b8;
        }
        .badge-warning {
            background-color: #ffc107;
            color: #212529;
        }
        .document-table {
            box-shadow: 0 0 20px rgba(0,0,0,0.1);
        }
        .document-table th {
            background-color: #f8f9fa;
            font-weight: 600;
        }
        .action-buttons .btn {
            margin-right: 5px;
        }
    </style>
</head>
<body>

<?php include 'student-navbar.php'; ?>

<div class="container py-5">
    <div class="d-flex justify-content-between align-items-center mb-4">
        <div>
            <h1 class="display-5">My Documents</h1>
            <p class="lead text-muted">Manage your application documents</p>
        </div>
        <a href="upload-document.php" class="btn btn-primary">
            <i class="fas fa-upload mr-2"></i>Upload New Document
        </a>
    </div>

    <?php if (empty($documents)): ?>
        <div class="text-center py-5">
            <i class="fas fa-file-alt fa-4x text-muted mb-4"></i>
            <h4 class="mb-3">No documents uploaded yet</h4>
            <p class="text-muted mb-4">Upload your documents to complete your application</p>
            <a href="upload-document.php" class="btn btn-primary btn-lg">
                <i class="fas fa-upload mr-2"></i>Upload First Document
            </a>
        </div>
    <?php else: ?>
        <div class="table-responsive">
            <table class="table table-bordered document-table">
                <thead class="thead-light">
                    <tr>
                        <th>Document Type</th>
                        <th>Status</th>
                        <th>Upload Date</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($documents as $doc): ?>
                    <tr>
                        <td><?= htmlspecialchars(ucfirst($doc['document_type'])) ?></td>
                        <td>
                            <span class="badge badge-<?php 
                                if ($doc['status'] === 'approved') {
                                    echo 'success';
                                } elseif ($doc['status'] === 'uploaded') {
                                    echo 'info';
                                } else {
                                    echo 'warning';
                                }
                            ?>">
                                <?= htmlspecialchars(ucfirst($doc['status'])) ?>
                            </span>
                        </td>
                        <td><?= date('M j, Y', strtotime($doc['created_at'])) ?></td>
                        <td class="action-buttons">
                            <a href="<?= htmlspecialchars($doc['file_path']) ?>" 
                               class="btn btn-sm btn-primary" 
                               target="_blank">
                                <i class="fas fa-eye mr-1"></i>View
                            </a>
                            <?php if ($doc['status'] !== 'approved'): ?>
                            <a href="upload-document.php?document_id=<?= $doc['id'] ?>" 
                               class="btn btn-sm btn-warning">
                                <i class="fas fa-redo mr-1"></i>Re-upload
                            </a>
                            <?php endif; ?>
                        </td>
                    </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        </div>
    <?php endif; ?>
</div>

<?php include 'footer.php'; ?>

<script src="https://code.jquery.com/jquery-3.4.1.min.js"></script>
<script src="https://stackpath.bootstrapcdn.com/bootstrap/4.4.1/js/bootstrap.bundle.min.js"></script>
</body>
</html>